/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content.cleanser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.alfresco.error.AlfrescoRuntimeException;

public abstract class ContentCleanser {
    protected OverwriteOperation overwriteZeros = new OverwriteOperation(this){

        @Override
        public void operation(OutputStream os) throws IOException {
            os.write(0);
        }
    };
    protected OverwriteOperation overwriteOnes = new OverwriteOperation(this){

        @Override
        public void operation(OutputStream os) throws IOException {
            os.write(255);
        }
    };
    protected OverwriteOperation overwriteRandom = new OverwriteOperation(this){
        private Random random = new Random();

        @Override
        public void operation(OutputStream os) throws IOException {
            byte[] randomByte = new byte[1];
            this.random.nextBytes(randomByte);
            os.write(randomByte[0]);
        }
    };

    public abstract void cleanse(File var1);

    protected void overwrite(File file, OverwriteOperation overwriteOperation) {
        long bytes = file.length();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            int i = 0;
            while ((long)i < bytes) {
                overwriteOperation.operation(os);
                ++i;
            }
        }
        catch (IOException ioException) {
            throw new AlfrescoRuntimeException("Unable to overwrite file", (Throwable)ioException);
        }
    }

    protected abstract class OverwriteOperation {
        protected OverwriteOperation(ContentCleanser this$0) {
        }

        public abstract void operation(OutputStream var1) throws IOException;
    }
}

