/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.report.generator.transfer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.report.generator.DeclarativeReportGenerator;
import org.alfresco.module.org_alfresco_module_rm.report.generator.transfer.TransferNode;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class TransferReportGenerator
extends DeclarativeReportGenerator {
    protected DispositionService dispositionService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    @Override
    protected Map<String, Serializable> generateReportTemplateContext(NodeRef reportedUponNodeRef) {
        List<TransferNode> transferNodes = this.getTransferNodes(reportedUponNodeRef);
        String dispositionAuthority = this.getDispositionAuthority(transferNodes);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>(2);
        properties.put("transferNodes", (ArrayList)transferNodes);
        properties.put("dispositionAuthority", (Serializable)((Object)dispositionAuthority));
        return properties;
    }

    private List<TransferNode> getTransferNodes(NodeRef nodeRef) {
        List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        ArrayList<TransferNode> transferNodes = new ArrayList<TransferNode>(assocs.size());
        for (ChildAssociationRef assoc : assocs) {
            NodeRef childRef = assoc.getChildRef();
            Map<String, Serializable> properties = this.getTransferNodeProperties(childRef);
            transferNodes.add(new TransferNode(childRef, properties));
        }
        return transferNodes;
    }

    private Map<String, Serializable> getTransferNodeProperties(NodeRef childRef) {
        HashMap<String, Serializable> transferNodeProperties = new HashMap<String, Serializable>(6);
        boolean isFolder = this.dictionaryService.isSubClass(this.nodeService.getType(childRef), ContentModel.TYPE_FOLDER);
        transferNodeProperties.put("isFolder", Boolean.valueOf(isFolder));
        if (isFolder) {
            Map<String, Serializable> folderProperties = this.getFolderProperties(childRef);
            transferNodeProperties.putAll(folderProperties);
        } else {
            Map<String, Serializable> recordProperties = this.getRecordProperties(childRef);
            transferNodeProperties.putAll(recordProperties);
        }
        return transferNodeProperties;
    }

    private List<TransferNode> getRecords(NodeRef childRef) {
        ArrayList<TransferNode> records = new ArrayList<TransferNode>(4);
        List assocs = this.nodeService.getChildAssocs(childRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : assocs) {
            NodeRef record = child.getChildRef();
            if (!this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD)) continue;
            Map<String, Serializable> recordProperties = this.getRecordProperties(record);
            TransferNode transferNode = new TransferNode(record, recordProperties);
            records.add(transferNode);
        }
        return records;
    }

    private Map<String, Serializable> getCommonProperties(NodeRef nodeRef) {
        HashMap<String, Serializable> transferNodeProperties = new HashMap<String, Serializable>(3);
        Map properties = this.nodeService.getProperties(nodeRef);
        String name = (String)properties.get(ContentModel.PROP_NAME);
        String identifier = (String)properties.get(RecordsManagementModel.PROP_IDENTIFIER);
        transferNodeProperties.put("name", (Serializable)((Object)name));
        transferNodeProperties.put("identifier", (Serializable)((Object)identifier));
        return transferNodeProperties;
    }

    private Map<String, Serializable> getFolderProperties(NodeRef folder) {
        HashMap<String, Serializable> transferNodeProperties = new HashMap<String, Serializable>(3);
        Map<String, Serializable> commonProperties = this.getCommonProperties(folder);
        ArrayList records = (ArrayList)this.getRecords(folder);
        transferNodeProperties.putAll(commonProperties);
        transferNodeProperties.put("records", records);
        return transferNodeProperties;
    }

    private Map<String, Serializable> getRecordProperties(NodeRef record) {
        HashMap<String, Serializable> transferNodeProperties = new HashMap<String, Serializable>(5);
        Map properties = this.nodeService.getProperties(record);
        String declaredBy = (String)properties.get(RecordsManagementModel.PROP_DECLARED_BY);
        Date declaredOn = (Date)properties.get(RecordsManagementModel.PROP_DECLARED_AT);
        boolean isDeclared = this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_DECLARED_RECORD);
        Map<String, Serializable> commonProperties = this.getCommonProperties(record);
        transferNodeProperties.putAll(commonProperties);
        transferNodeProperties.put("declaredBy", (Serializable)((Object)declaredBy));
        transferNodeProperties.put("declaredOn", declaredOn);
        transferNodeProperties.put("isDeclared", Boolean.valueOf(isDeclared));
        return transferNodeProperties;
    }

    private String getDispositionAuthority(List<TransferNode> transferNodes) {
        NodeRef nodeRef;
        DispositionSchedule ds;
        String dispositionAuthority = null;
        if (transferNodes.size() > 0 && (ds = this.dispositionService.getDispositionSchedule(nodeRef = transferNodes.iterator().next().getNodeRef())) != null) {
            dispositionAuthority = ds.getDispositionAuthority();
        }
        return dispositionAuthority == null ? "" : dispositionAuthority;
    }
}

