/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionServiceImpl;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.springframework.beans.factory.BeanNameAware;

public class RMv21RecordInheritancePatch
extends RMv21PatchComponent
implements BeanNameAware,
RecordsManagementModel,
DOD5015Model {
    private FilePlanPermissionServiceImpl filePlanPermissionServiceImpl;
    private NodeService nodeService;
    private PatchDAO patchDAO;
    private QNameDAO qnameDAO;
    private NodeDAO nodeDAO;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setFilePlanPermissionServiceImpl(FilePlanPermissionServiceImpl filePlanPermissionServiceImpl) {
        this.filePlanPermissionServiceImpl = filePlanPermissionServiceImpl;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executePatch() {
        Pair aspectPair = this.qnameDAO.getQName(ASPECT_RECORD);
        if (aspectPair != null) {
            List records = this.patchDAO.getNodesByAspectQNameId((Long)aspectPair.getFirst(), Long.valueOf(0L), Long.valueOf(this.patchDAO.getMaxAdmNodeID()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  ... updating " + records.size() + " records");
            }
            for (Long record : records) {
                Pair recordPair = this.nodeDAO.getNodePair(record);
                NodeRef recordNodeRef = (NodeRef)recordPair.getSecond();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("  ... updating record " + recordNodeRef.toString());
                ChildAssociationRef assoc = this.nodeService.getPrimaryParent(recordNodeRef);
                NodeRef parent = assoc.getParentRef();
                if (parent == null) continue;
                this.filePlanPermissionServiceImpl.setupPermissions(parent, recordNodeRef);
            }
        }
    }
}

