/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditQueryParameters;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BaseAuditRetrievalWebScript
extends StreamContent {
    private static Log logger = LogFactory.getLog(BaseAuditRetrievalWebScript.class);
    private static final String PARAM_USER = "user";
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_EVENT = "event";
    private static final String PARAM_FROM = "from";
    private static final String PARAM_TO = "to";
    private static final String PARAM_PROPERTY = "property";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    protected RecordsManagementAuditService rmAuditService;
    protected NamespaceService namespaceService;

    public void setRecordsManagementAuditService(RecordsManagementAuditService rmAuditService) {
        this.rmAuditService = rmAuditService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected RecordsManagementAuditQueryParameters parseQueryParameters(WebScriptRequest req) {
        RecordsManagementAuditQueryParameters params;
        block29: {
            String property;
            block28: {
                SimpleDateFormat dateFormat;
                String to;
                block27: {
                    String from;
                    block26: {
                        String event;
                        String user;
                        String size;
                        NodeRef nodeRef;
                        block25: {
                            params = new RecordsManagementAuditQueryParameters();
                            nodeRef = null;
                            Map templateVars = req.getServiceMatch().getTemplateVars();
                            String storeType = (String)templateVars.get("store_type");
                            if (storeType != null && storeType.length() > 0) {
                                String storeId = (String)templateVars.get("store_id");
                                String nodeId = (String)templateVars.get("id");
                                nodeRef = new NodeRef(new StoreRef(storeType, storeId), nodeId);
                            }
                            size = null;
                            user = null;
                            event = null;
                            from = null;
                            to = null;
                            property = null;
                            if ("application/json".equals(req.getContentType())) {
                                try {
                                    JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
                                    if (json.has(PARAM_SIZE)) {
                                        size = json.getString(PARAM_SIZE);
                                    }
                                    if (json.has(PARAM_USER)) {
                                        user = json.getString(PARAM_USER);
                                    }
                                    if (json.has(PARAM_EVENT)) {
                                        event = json.getString(PARAM_EVENT);
                                    }
                                    if (json.has(PARAM_FROM)) {
                                        from = json.getString(PARAM_FROM);
                                    }
                                    if (json.has(PARAM_TO)) {
                                        to = json.getString(PARAM_TO);
                                    }
                                    if (json.has(PARAM_PROPERTY)) {
                                        property = json.getString(PARAM_PROPERTY);
                                    }
                                    break block25;
                                }
                                catch (IOException ioe) {
                                    if (logger.isWarnEnabled()) {
                                        logger.warn((Object)("Failed to parse JSON parameters for audit query: " + ioe.getMessage()));
                                    }
                                    break block25;
                                }
                                catch (JSONException je) {
                                    if (logger.isWarnEnabled()) {
                                        logger.warn((Object)("Failed to parse JSON parameters for audit query: " + je.getMessage()));
                                    }
                                    break block25;
                                }
                            }
                            size = req.getParameter(PARAM_SIZE);
                            user = req.getParameter(PARAM_USER);
                            event = req.getParameter(PARAM_EVENT);
                            from = req.getParameter(PARAM_FROM);
                            to = req.getParameter(PARAM_TO);
                            property = req.getParameter(PARAM_PROPERTY);
                        }
                        params.setNodeRef(nodeRef);
                        params.setUser(user);
                        params.setEvent(event);
                        if (size != null && size.length() > 0) {
                            try {
                                params.setMaxEntries(Integer.parseInt(size));
                            }
                            catch (NumberFormatException nfe) {
                                if (!logger.isWarnEnabled()) break block26;
                                logger.warn((Object)("Ignoring size parameter as '" + size + "' is not a number!"));
                            }
                        }
                    }
                    if (from != null && from.length() > 0) {
                        try {
                            dateFormat = new SimpleDateFormat(DATE_PATTERN);
                            params.setDateFrom(dateFormat.parse(from));
                        }
                        catch (ParseException pe) {
                            if (!logger.isWarnEnabled()) break block27;
                            logger.warn((Object)("Ignoring from parameter as '" + from + "' does not conform to the date pattern: yyyy-MM-dd"));
                        }
                    }
                }
                if (to != null && to.length() > 0) {
                    try {
                        dateFormat = new SimpleDateFormat(DATE_PATTERN);
                        params.setDateTo(dateFormat.parse(to));
                    }
                    catch (ParseException pe) {
                        if (!logger.isWarnEnabled()) break block28;
                        logger.warn((Object)("Ignoring to parameter as '" + to + "' does not conform to the date pattern: yyyy-MM-dd"));
                    }
                }
            }
            if (property != null && property.length() > 0) {
                try {
                    params.setProperty(QName.createQName((String)property, (NamespacePrefixResolver)this.namespaceService));
                }
                catch (InvalidQNameException iqe) {
                    if (!logger.isWarnEnabled()) break block29;
                    logger.warn((Object)("Ignoring property parameter as '" + property + "' is an invalid QName"));
                }
            }
        }
        return params;
    }

    protected RecordsManagementAuditService.ReportFormat parseReportFormat(WebScriptRequest req) {
        String format = req.getFormat();
        if (format != null) {
            if (format.equalsIgnoreCase("json")) {
                return RecordsManagementAuditService.ReportFormat.JSON;
            }
            if (format.equalsIgnoreCase("html")) {
                return RecordsManagementAuditService.ReportFormat.HTML;
            }
        }
        return RecordsManagementAuditService.ReportFormat.JSON;
    }
}

