/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.util.StringUtils;

public class DispositionPropertiesGet
extends DeclarativeWebScript {
    protected DispositionService dispositionService;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        boolean recordLevel = false;
        String recordLevelValue = req.getParameter("recordlevel");
        if (recordLevelValue != null) {
            recordLevel = Boolean.valueOf(recordLevelValue);
        }
        String dispositionAction = req.getParameter("dispositionaction");
        Collection<DispositionProperty> dispositionProperties = this.dispositionService.getDispositionProperties(recordLevel, dispositionAction);
        ArrayList items = new ArrayList(dispositionProperties.size());
        for (DispositionProperty dispositionProperty : dispositionProperties) {
            PropertyDefinition propDef = dispositionProperty.getPropertyDefinition();
            QName propName = dispositionProperty.getQName();
            if (propDef == null) continue;
            HashMap<String, String> item = new HashMap<String, String>(2);
            String propTitle = propDef.getTitle((MessageLookup)this.dictionaryService);
            if (propTitle == null || propTitle.length() == 0) {
                propTitle = StringUtils.capitalize((String)propName.getLocalName());
            }
            item.put("label", propTitle);
            item.put("value", propName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("properties", items);
        return model;
    }
}

