/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

@AlfrescoPublicApi
public final class RecordsManagementAuditEntry {
    private final Date timestamp;
    private final String userName;
    private final String fullName;
    private final String userRole;
    private final NodeRef nodeRef;
    private final String nodeName;
    private final String nodeType;
    private final String event;
    private final String identifier;
    private final String path;
    private final Map<QName, Serializable> beforeProperties;
    private final Map<QName, Serializable> afterProperties;
    private Map<QName, Pair<Serializable, Serializable>> changedProperties;

    public RecordsManagementAuditEntry(Date timestamp, String userName, String fullName, String userRole, NodeRef nodeRef, String nodeName, String nodeType, String event, String identifier, String path, Map<QName, Serializable> beforeProperties, Map<QName, Serializable> afterProperties) {
        ParameterCheck.mandatory((String)"timestamp", (Object)timestamp);
        ParameterCheck.mandatory((String)"userName", (Object)userName);
        this.timestamp = timestamp;
        this.userName = userName;
        this.userRole = userRole;
        this.fullName = fullName;
        this.nodeRef = nodeRef;
        this.nodeName = nodeName;
        this.nodeType = nodeType;
        this.event = event;
        this.identifier = identifier;
        this.path = path;
        this.beforeProperties = beforeProperties;
        this.afterProperties = afterProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append("timestamp=").append(this.timestamp).append(", userName=").append(this.userName).append(", userRole=").append(this.userRole).append(", fullName=").append(this.fullName).append(", nodeRef=").append(this.nodeRef).append(", nodeName=").append(this.nodeName).append(", event=").append(this.event).append(", identifier=").append(this.identifier).append(", path=").append(this.path).append(", beforeProperties=").append(this.beforeProperties).append(", afterProperties=").append(this.afterProperties).append(", changedProperties=").append(this.changedProperties).append(")");
        return sb.toString();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return ISO8601DateFormat.format((Date)this.timestamp);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getEvent() {
        return this.event;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPath() {
        return this.path;
    }

    public Map<QName, Serializable> getBeforeProperties() {
        return this.beforeProperties;
    }

    public Map<QName, Serializable> getAfterProperties() {
        return this.afterProperties;
    }

    public Map<QName, Pair<Serializable, Serializable>> getChangedProperties() {
        if (this.changedProperties == null) {
            this.initChangedProperties();
        }
        return this.changedProperties;
    }

    private void initChangedProperties() {
        if (this.beforeProperties != null && this.afterProperties != null) {
            Pair values;
            QName valuePropName;
            this.changedProperties = new HashMap<QName, Pair<Serializable, Serializable>>(this.beforeProperties.size() + this.afterProperties.size());
            for (Map.Entry<QName, Serializable> entry : this.beforeProperties.entrySet()) {
                valuePropName = entry.getKey();
                values = new Pair((Object)entry.getValue(), (Object)this.afterProperties.get(valuePropName));
                this.changedProperties.put(valuePropName, (Pair<Serializable, Serializable>)values);
            }
            for (Map.Entry<QName, Serializable> entry : this.afterProperties.entrySet()) {
                valuePropName = entry.getKey();
                if (this.beforeProperties.containsKey(valuePropName)) continue;
                values = new Pair(null, (Object)entry.getValue());
                this.changedProperties.put(valuePropName, (Pair<Serializable, Serializable>)values);
            }
        }
    }
}

