/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.hold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.script.hold.Hold;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class HoldsGet
extends DeclarativeWebScript {
    private FilePlanService filePlanService;
    private NodeService nodeService;
    private HoldService holdService;
    private PermissionService permissionService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        boolean fileOnly = this.getFileOnly(req);
        NodeRef itemNodeRef = this.getItemNodeRef(req);
        ArrayList<NodeRef> holds = new ArrayList<NodeRef>();
        if (itemNodeRef == null) {
            NodeRef filePlan = this.getFilePlan(req);
            holds.addAll(this.holdService.getHolds(filePlan));
        } else {
            boolean includedInHold = this.getIncludedInHold(req);
            holds.addAll(this.holdService.heldBy(itemNodeRef, includedInHold));
        }
        ArrayList<Hold> holdObjects = new ArrayList<Hold>(holds.size());
        for (NodeRef nodeRef : holds) {
            if (fileOnly && this.permissionService.hasPermission(nodeRef, "Filing") != AccessStatus.ALLOWED) continue;
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            holdObjects.add(new Hold(name, nodeRef));
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        this.sortHoldByName(holdObjects);
        model.put("holds", holdObjects);
        return model;
    }

    private NodeRef getFilePlan(WebScriptRequest req) {
        NodeRef filePlan = null;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        String storeId = (String)templateVars.get("store_id");
        String id = (String)templateVars.get("id");
        if (StringUtils.isNotBlank((CharSequence)storeType) && StringUtils.isNotBlank((CharSequence)storeId) && StringUtils.isNotBlank((CharSequence)id)) {
            filePlan = new NodeRef(new StoreRef(storeType, storeId), id);
            if (!this.nodeService.exists(filePlan) || !this.filePlanService.isFilePlan(filePlan)) {
                throw new WebScriptException(404, "The file plan provided could not be found.");
            }
        } else {
            filePlan = this.filePlanService.getFilePlanBySiteId("rm");
            if (filePlan == null) {
                throw new WebScriptException(404, "The default file plan node could not be found.");
            }
        }
        return filePlan;
    }

    private NodeRef getItemNodeRef(WebScriptRequest req) {
        String nodeRef = req.getParameter("itemNodeRef");
        NodeRef itemNodeRef = null;
        if (StringUtils.isNotBlank((CharSequence)nodeRef)) {
            itemNodeRef = new NodeRef(nodeRef);
        }
        return itemNodeRef;
    }

    private boolean getIncludedInHold(WebScriptRequest req) {
        boolean result = true;
        String includedInHold = req.getParameter("includedInHold");
        if (StringUtils.isNotBlank((CharSequence)includedInHold)) {
            result = Boolean.parseBoolean(includedInHold);
        }
        return result;
    }

    private boolean getFileOnly(WebScriptRequest req) {
        boolean result = false;
        String fillingOnly = req.getParameter("fileOnly");
        if (StringUtils.isNotBlank((CharSequence)fillingOnly)) {
            result = Boolean.parseBoolean(fillingOnly);
        }
        return result;
    }

    private void sortHoldByName(List<Hold> holds) {
        Collections.sort(holds, new Comparator<Hold>(this){

            @Override
            public int compare(Hold h1, Hold h2) {
                return h1.getName().toLowerCase().compareTo(h2.getName().toLowerCase());
            }
        });
    }
}

