/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1799Test
extends BaseRMTestCase {
    private String myUser;
    private NodeRef category;

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.myUser = GUID.generate();
        this.createPerson(this.myUser);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.myUser);
    }

    public void testRM1799() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1799Test.this.filePlanPermissionService.setPermission(RM1799Test.this.filePlan, RM1799Test.this.myUser, "Filing");
                return null;
            }
        }, "admin");
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1799Test.this.category = RM1799Test.this.filePlanService.createRecordCategory(RM1799Test.this.filePlan, GUID.generate());
                return null;
            }
        }, this.myUser);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM1799Test.this.permissionService.hasPermission(RM1799Test.this.category, "Filing"));
                return null;
            }
        }, this.myUser);
    }
}

