/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch;

import java.util.concurrent.TimeUnit;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatch;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatchExecuter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractModulePatch
implements ModulePatch,
BeanNameAware {
    protected static final Log LOGGER = LogFactory.getLog(ModulePatch.class);
    private ModulePatchExecuter modulePatchExecuter;
    protected TransactionService transactionService;
    private String id;
    private String description;
    private String moduleId;
    private int fixesFromSchema;
    private int fixesToSchema;
    private int targetSchema;
    private boolean txnReadOnly = true;
    private boolean txnRequiresNew = false;

    public void init() {
        this.modulePatchExecuter.register(this);
    }

    public void setTxnReadOnly(boolean txnReadOnly) {
        this.txnReadOnly = txnReadOnly;
    }

    public void setTxnRequiresNew(boolean txnRequiresNew) {
        this.txnRequiresNew = txnRequiresNew;
    }

    public void setModulePatchExecuter(ModulePatchExecuter modulePatchExecuter) {
        this.modulePatchExecuter = modulePatchExecuter;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setBeanName(String beanName) {
        if (this.id == null) {
            this.id = beanName;
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    public void setFixesFromSchema(int fixesFromSchema) {
        this.fixesFromSchema = fixesFromSchema;
    }

    @Override
    public int getFixesFromSchema() {
        return this.fixesFromSchema;
    }

    public void setFixesToSchema(int fixesToSchema) {
        this.fixesToSchema = fixesToSchema;
    }

    @Override
    public int getFixesToSchema() {
        return this.fixesToSchema;
    }

    public void setTargetSchema(int targetSchema) {
        this.targetSchema = targetSchema;
    }

    @Override
    public int getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    public void apply() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Executing module patch \"" + this.description + "\""));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("   ... id=" + this.id + ",moduleId=" + this.moduleId + ",from=" + this.fixesFromSchema + ",to=" + this.fixesToSchema + ",target=" + this.targetSchema));
        }
        long startTime = System.nanoTime();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new ApplyCallback(), this.txnReadOnly, this.txnRequiresNew);
        long elapsedTime = System.nanoTime() - startTime;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("   ... module patch applied in " + TimeUnit.NANOSECONDS.toMillis(elapsedTime) + "ms"));
        }
    }

    public abstract void applyInternal();

    @Override
    public int compareTo(ModulePatch o) {
        int result = 0;
        if (this.getTargetSchema() < o.getTargetSchema()) {
            result = -1;
        } else if (this.getTargetSchema() > o.getTargetSchema()) {
            result = 1;
        }
        return result;
    }

    private class ApplyCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Void> {
        private ApplyCallback() {
        }

        public Void execute() {
            AbstractModulePatch.this.applyInternal();
            return null;
        }
    }
}

