/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;

public class RMv21CapabilityPatch
extends RMv21PatchComponent {
    private FilePlanService filePlanService;
    private AuthorityService authorityService;
    private PermissionService permissionService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Set<NodeRef> getFilePlans() {
        return this.filePlanService.getFilePlans();
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private void addCapability(NodeRef filePlan, String capabilityName, String ... roles) {
        for (String role : roles) {
            String fullRoleName = role + filePlan.getId();
            String roleAuthority = this.authorityService.getName(AuthorityType.GROUP, fullRoleName);
            if (roleAuthority == null) {
                throw new AlfrescoRuntimeException("Role " + role + " does not exist.");
            }
            this.permissionService.setPermission(filePlan, roleAuthority, capabilityName, true);
        }
    }

    @Override
    protected void executePatch() {
        Set<NodeRef> filePlans = this.getFilePlans();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ... updating " + filePlans.size() + " file plans");
        }
        for (NodeRef filePlan : filePlans) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  ... updating file plan " + filePlan.toString());
            }
            this.addCapability(filePlan, "CreateRecords", "Administrator", "PowerUser", "RecordsManager", "SecurityOfficer");
            this.addCapability(filePlan, "ManageRules", "Administrator");
            this.addCapability(filePlan, "RequestRecordInformation", "Administrator", "PowerUser", "RecordsManager", "SecurityOfficer");
            this.addCapability(filePlan, "FileDestructionReport", "Administrator", "RecordsManager");
            this.addCapability(filePlan, "RejectRecords", "Administrator", "PowerUser", "RecordsManager", "SecurityOfficer");
            this.addCapability(filePlan, "FileUnfiledRecords", "Administrator", "PowerUser", "RecordsManager", "SecurityOfficer");
            this.addCapability(filePlan, "LinkToRecords", "Administrator", "PowerUser", "RecordsManager", "SecurityOfficer");
        }
    }
}

