/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSet;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class DataSetServiceImplTest
extends BaseRMTestCase {
    private static final String DATA_SET_ID = "testExampleData";

    public void testGetDataSets() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Map dataSets = DataSetServiceImplTest.this.dataSetService.getDataSets();
                TestCase.assertNotNull((Object)dataSets);
                TestCase.assertTrue((dataSets.size() >= 1 ? 1 : 0) != 0);
                TestCase.assertNotNull(dataSets.get(DataSetServiceImplTest.DATA_SET_ID));
                for (Map.Entry entry : dataSets.entrySet()) {
                    String key = (String)entry.getKey();
                    TestCase.assertNotNull((Object)key);
                    DataSet dataSet = (DataSet)entry.getValue();
                    TestCase.assertNotNull((Object)dataSet);
                    String id = dataSet.getId();
                    TestCase.assertNotNull((Object)id);
                    TestCase.assertEquals((String)id, (String)key);
                    String label = dataSet.getLabel();
                    TestCase.assertNotNull((Object)label);
                    String path = dataSet.getPath();
                    TestCase.assertNotNull((Object)path);
                }
                return null;
            }
        });
    }

    public void testLoadDataSet() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                this.testFilePlanBeforeImportingDataSet();
                DataSetServiceImplTest.this.dataSetService.loadDataSet(DataSetServiceImplTest.this.filePlan, DataSetServiceImplTest.DATA_SET_ID);
                this.testFilePlanAfterImportingDataSet();
                return null;
            }

            private void testFilePlanBeforeImportingDataSet() {
                TestCase.assertNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(DataSetServiceImplTest.this.filePlan, ContentModel.ASSOC_CONTAINS, "TestRecordCategory1"));
                TestCase.assertNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(DataSetServiceImplTest.this.filePlan, ContentModel.ASSOC_CONTAINS, "TestRecordCategory2"));
                TestCase.assertNull((Object)DataSetServiceImplTest.this.nodeService.getProperty(DataSetServiceImplTest.this.filePlan, RecordsManagementModel.PROP_LOADED_DATA_SET_IDS));
                TestCase.assertTrue((DataSetServiceImplTest.this.dataSetService.getLoadedDataSets(DataSetServiceImplTest.this.filePlan).size() == 0 ? 1 : 0) != 0);
                TestCase.assertFalse((boolean)DataSetServiceImplTest.this.dataSetService.isLoadedDataSet(DataSetServiceImplTest.this.filePlan, DataSetServiceImplTest.DATA_SET_ID));
                TestCase.assertTrue((DataSetServiceImplTest.this.dataSetService.getDataSets(DataSetServiceImplTest.this.filePlan, true).size() > 0 ? 1 : 0) != 0);
                TestCase.assertTrue((DataSetServiceImplTest.this.dataSetService.getDataSets(DataSetServiceImplTest.this.filePlan, false).size() > 0 ? 1 : 0) != 0);
            }

            private void testFilePlanAfterImportingDataSet() {
                NodeRef recCat1 = DataSetServiceImplTest.this.nodeService.getChildByName(DataSetServiceImplTest.this.filePlan, ContentModel.ASSOC_CONTAINS, "TestRecordCategory1");
                TestCase.assertNotNull((Object)recCat1);
                List recCat1ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat1);
                TestCase.assertTrue((recCat1ImmediateChildren.size() == 3 ? 1 : 0) != 0);
                List recCat1AllChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat1, true);
                TestCase.assertTrue((recCat1AllChildren.size() == 6 ? 1 : 0) != 0);
                DispositionSchedule recCat1DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat1);
                TestCase.assertNull((Object)recCat1DispositionSchedule);
                NodeRef recCat2 = DataSetServiceImplTest.this.nodeService.getChildByName(DataSetServiceImplTest.this.filePlan, ContentModel.ASSOC_CONTAINS, "TestRecordCategory2");
                TestCase.assertNotNull((Object)recCat2);
                List recCat2ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat2);
                TestCase.assertTrue((recCat2ImmediateChildren.size() == 2 ? 1 : 0) != 0);
                List recCat2AllChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat2, true);
                TestCase.assertTrue((recCat2AllChildren.size() == 4 ? 1 : 0) != 0);
                DispositionSchedule recCat2DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat2);
                TestCase.assertNull((Object)recCat2DispositionSchedule);
                NodeRef recCat11 = DataSetServiceImplTest.this.nodeService.getChildByName(recCat1, ContentModel.ASSOC_CONTAINS, "TestRecordCategory11");
                TestCase.assertNotNull((Object)recCat11);
                List recCat11ImmediateChilderen = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat11);
                TestCase.assertTrue((recCat11ImmediateChilderen.size() == 2 ? 1 : 0) != 0);
                List recCat11Childeren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat11, true);
                TestCase.assertTrue((recCat11Childeren.size() == 2 ? 1 : 0) != 0);
                TestCase.assertNotNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(recCat11, ContentModel.ASSOC_CONTAINS, "TestRecordFolder1"));
                TestCase.assertNotNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(recCat11, ContentModel.ASSOC_CONTAINS, "TestRecordFolder2"));
                VitalRecordDefinition recCat11VitalRecordDefinition = DataSetServiceImplTest.this.vitalRecordService.getVitalRecordDefinition(recCat11);
                TestCase.assertNotNull((Object)recCat11VitalRecordDefinition);
                TestCase.assertTrue((boolean)recCat11VitalRecordDefinition.getReviewPeriod().getExpression().equals("1"));
                TestCase.assertNotNull((Object)recCat11VitalRecordDefinition.getNextReviewDate());
                NodeRef recCat12 = DataSetServiceImplTest.this.nodeService.getChildByName(recCat1, ContentModel.ASSOC_CONTAINS, "TestRecordCategory12");
                TestCase.assertNotNull((Object)recCat12);
                List recCat12ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat12);
                TestCase.assertTrue((recCat12ImmediateChildren.size() == 1 ? 1 : 0) != 0);
                List recCat12Children = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat12, true);
                TestCase.assertTrue((recCat12Children.size() == 1 ? 1 : 0) != 0);
                TestCase.assertNotNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(recCat12, ContentModel.ASSOC_CONTAINS, "TestRecordFolder3"));
                DispositionSchedule recCat12DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat12);
                TestCase.assertNotNull((Object)recCat12DispositionSchedule);
                TestCase.assertTrue((boolean)recCat12DispositionSchedule.getDispositionInstructions().equals("Cut off every 3 months, hold 3 months, then destroy."));
                TestCase.assertTrue((boolean)recCat12DispositionSchedule.getDispositionAuthority().equals("T0-000-00-1 item 002"));
                TestCase.assertTrue((recCat12DispositionSchedule.getDispositionActionDefinitions().size() == 2 ? 1 : 0) != 0);
                TestCase.assertNotNull((Object)recCat12DispositionSchedule.getDispositionActionDefinitionByName("cutoff"));
                TestCase.assertNotNull((Object)recCat12DispositionSchedule.getDispositionActionDefinitionByName("destroy"));
                NodeRef recCat13 = DataSetServiceImplTest.this.nodeService.getChildByName(recCat1, ContentModel.ASSOC_CONTAINS, "TestRecordCategory13");
                TestCase.assertNotNull((Object)recCat13);
                List recCat13ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat13);
                TestCase.assertTrue((recCat13ImmediateChildren.size() == 0 ? 1 : 0) != 0);
                DispositionSchedule recCat13DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat13);
                TestCase.assertNotNull((Object)recCat13DispositionSchedule);
                NodeRef recCat21 = DataSetServiceImplTest.this.nodeService.getChildByName(recCat2, ContentModel.ASSOC_CONTAINS, "TestRecordCategory21");
                TestCase.assertNotNull((Object)recCat21);
                List recCat21ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat21);
                TestCase.assertTrue((recCat21ImmediateChildren.size() == 0 ? 1 : 0) != 0);
                DispositionSchedule recCat21DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat21);
                TestCase.assertNotNull((Object)recCat21DispositionSchedule);
                NodeRef recCat22 = DataSetServiceImplTest.this.nodeService.getChildByName(recCat2, ContentModel.ASSOC_CONTAINS, "TestRecordCategory22");
                TestCase.assertNotNull((Object)recCat22);
                List recCat22ImmediateChildren = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat22);
                TestCase.assertTrue((recCat22ImmediateChildren.size() == 2 ? 1 : 0) != 0);
                List recCat22Children = DataSetServiceImplTest.this.filePlanService.getAllContained(recCat22, true);
                TestCase.assertTrue((recCat22Children.size() == 2 ? 1 : 0) != 0);
                TestCase.assertNotNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(recCat22, ContentModel.ASSOC_CONTAINS, "TestRecordFolder4"));
                TestCase.assertNotNull((Object)DataSetServiceImplTest.this.nodeService.getChildByName(recCat22, ContentModel.ASSOC_CONTAINS, "TestRecordFolder5"));
                DispositionSchedule recCat22DispositionSchedule = DataSetServiceImplTest.this.dispositionService.getDispositionSchedule(recCat22);
                TestCase.assertNotNull((Object)recCat22DispositionSchedule);
                Serializable nodeProperty = DataSetServiceImplTest.this.nodeService.getProperty(DataSetServiceImplTest.this.filePlan, RecordsManagementModel.PROP_LOADED_DATA_SET_IDS);
                TestCase.assertNotNull((Object)nodeProperty);
                ArrayList loadedDataSetIds = (ArrayList)nodeProperty;
                TestCase.assertTrue((loadedDataSetIds.size() == 1 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)loadedDataSetIds.contains(DataSetServiceImplTest.DATA_SET_ID));
                Map loadedDataSets = DataSetServiceImplTest.this.dataSetService.getLoadedDataSets(DataSetServiceImplTest.this.filePlan);
                TestCase.assertTrue((loadedDataSets.size() == 1 ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)loadedDataSets.containsKey(DataSetServiceImplTest.DATA_SET_ID));
                TestCase.assertTrue((boolean)DataSetServiceImplTest.this.dataSetService.isLoadedDataSet(DataSetServiceImplTest.this.filePlan, DataSetServiceImplTest.DATA_SET_ID));
                TestCase.assertTrue((DataSetServiceImplTest.this.dataSetService.getDataSets(DataSetServiceImplTest.this.filePlan, true).size() > 0 ? 1 : 0) != 0);
                TestCase.assertTrue((DataSetServiceImplTest.this.dataSetService.getDataSets(DataSetServiceImplTest.this.filePlan, false).size() > 1 ? 1 : 0) != 0);
            }
        });
    }

    public void testExistsDataSet() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertTrue((boolean)DataSetServiceImplTest.this.dataSetService.existsDataSet(DataSetServiceImplTest.DATA_SET_ID));
                TestCase.assertFalse((boolean)DataSetServiceImplTest.this.dataSetService.existsDataSet("AnotherDataSetId"));
                return null;
            }
        });
    }
}

