/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.report.generator;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.report.Report;
import org.alfresco.module.org_alfresco_module_rm.report.ReportGenerator;
import org.alfresco.module.org_alfresco_module_rm.report.ReportService;
import org.alfresco.module.org_alfresco_module_rm.report.generator.ReportInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

public abstract class BaseReportGenerator
implements ReportGenerator {
    protected ReportService reportService;
    protected NamespaceService namespaceService;
    protected QName reportType;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setReportType(QName reportType) {
        this.reportType = reportType;
    }

    @Override
    public QName getReportType() {
        return this.reportType;
    }

    public void init() {
        ParameterCheck.mandatory((String)"reportType", (Object)this.reportType);
        this.reportService.registerReportGenerator(this);
    }

    @Override
    public Report generateReport(NodeRef reportedUponNodeRef, String mimetype) {
        ParameterCheck.mandatory((String)"reportedUponNodeRef", (Object)reportedUponNodeRef);
        ParameterCheck.mandatoryString((String)"mimetype", (String)mimetype);
        this.checkReportApplicability(reportedUponNodeRef);
        String reportName = this.generateReportName(reportedUponNodeRef, mimetype);
        Map<QName, Serializable> reportProperties = this.generateReportMetadata(reportedUponNodeRef);
        ContentReader contentReader = this.generateReportContent(reportedUponNodeRef, mimetype, this.generateReportTemplateContext(reportedUponNodeRef));
        return new ReportInfo(this.reportType, reportName, reportProperties, contentReader);
    }

    protected abstract void checkReportApplicability(NodeRef var1);

    protected abstract String generateReportName(NodeRef var1, String var2);

    protected abstract Map<String, Serializable> generateReportTemplateContext(NodeRef var1);

    protected abstract Map<QName, Serializable> generateReportMetadata(NodeRef var1);

    protected abstract ContentReader generateReportContent(NodeRef var1, String var2, Map<String, Serializable> var3);
}

