/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.content.EagerContentStoreCleaner;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

public class EagerContentStoreCleanerUnitTest
extends BaseUnitTest {
    @InjectMocks
    private EagerContentStoreCleaner eagerContentStoreCleaner = new EagerContentStoreCleaner(this){

        public boolean registerOrphanedContentUrl(String contentUrl, boolean force) {
            return true;
        }
    };
    @Mock
    private ContentCleanser mockedContentCleanser;

    @Test
    public void registerContentURL() {
        String contentURL = AlfMock.generateText();
        Set mockedSet = (Set)Mockito.mock(Set.class);
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getSet((Object)"postCommitCleansingUrls")).thenReturn((Object)mockedSet);
        this.eagerContentStoreCleaner.registerOrphanedContentUrlForCleansing(contentURL);
        ((Set)Mockito.verify((Object)mockedSet)).add(contentURL);
    }

    @Test
    public void contentRequiresCleaning() {
        String contentURL = AlfMock.generateText();
        HashSet<String> mockedSet = new HashSet<String>(Arrays.asList(contentURL));
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getSet((Object)"postCommitCleansingUrls")).thenReturn(mockedSet);
        FileContentReader mockedReader = (FileContentReader)Mockito.mock(FileContentReader.class);
        Mockito.when((Object)mockedReader.exists()).thenReturn((Object)true);
        File mockedFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockedReader.getFile()).thenReturn((Object)mockedFile);
        ContentStore mockedContentStore = (ContentStore)Mockito.mock(ContentStore.class);
        Mockito.when((Object)mockedContentStore.getReader(contentURL)).thenReturn((Object)mockedReader);
        this.eagerContentStoreCleaner.deleteFromStore(contentURL, mockedContentStore);
        ((ContentCleanser)Mockito.verify((Object)this.mockedContentCleanser)).cleanse(mockedFile);
    }

    @Test
    public void contentDoesntRequireCleaning() {
        String contentURL = AlfMock.generateText();
        HashSet<String> mockedSet = new HashSet<String>(Arrays.asList(contentURL));
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getSet((Object)"postCommitCleansingUrls")).thenReturn(mockedSet);
        this.eagerContentStoreCleaner.deleteFromStore(AlfMock.generateText(), (ContentStore)Mockito.mock(ContentStore.class));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockedContentCleanser});
    }
}

