/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FPUtils {
    @SafeVarargs
    public static <T> List<T> asListFrom(Supplier<T> ... suppliers) {
        if (suppliers == null || suppliers.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(suppliers).map(s -> s.get()).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> Set<T> asSetFrom(Supplier<T> ... suppliers) {
        List<T> l = FPUtils.asListFrom(suppliers);
        return new HashSet<T>(l);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... objects) {
        return new HashSet<T>(Arrays.asList(objects));
    }
}

