/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.forms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ImapModel;
import org.alfresco.module.org_alfresco_module_rm.compatibility.CompatibilityModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionScheduleImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.forms.RecordsManagementFormFilter;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.forms.processor.node.FieldUtils;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordsManagementNodeFormFilter
extends RecordsManagementFormFilter<NodeRef>
implements RecordsManagementModel,
DOD5015Model {
    private static Log logger = LogFactory.getLog(RecordsManagementNodeFormFilter.class);
    protected static final String TRANSIENT_DECLARED = "rmDeclared";
    protected static final String TRANSIENT_CATEGORY_ID = "rmCategoryIdentifier";
    protected static final String TRANSIENT_DISPOSITION_INSTRUCTIONS = "rmDispositionInstructions";
    private DispositionService dispositionService;
    private FilePlanService filePlanService;

    protected DispositionService getDispositionService() {
        return this.dispositionService;
    }

    protected FilePlanService getFilePlanService() {
        return this.filePlanService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void afterGenerate(NodeRef nodeRef, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
        if (this.getFilePlanService().isFilePlanComponent(nodeRef)) {
            this.addCustomPropertyFieldsToGroup(form, nodeRef);
            FilePlanComponentKind kind = this.getFilePlanService().getFilePlanComponentKind(nodeRef);
            if (FilePlanComponentKind.RECORD.equals((Object)kind)) {
                this.addRecordMetadataPropertyFieldsToGroup(form, nodeRef);
                this.addTransientProperties(form, nodeRef);
                this.forceSupplementalMarkingListProperty(form, nodeRef);
                this.protectRecordProperties(form, nodeRef);
                if (this.nodeService.hasAspect(nodeRef, ImapModel.ASPECT_IMAP_CONTENT)) {
                    this.protectEmailExtractedFields(form, nodeRef);
                }
            } else if (FilePlanComponentKind.RECORD_FOLDER.equals((Object)kind)) {
                this.forceSupplementalMarkingListProperty(form, nodeRef);
                this.addTransientProperties(form, nodeRef);
            } else if (FilePlanComponentKind.DISPOSITION_SCHEDULE.equals((Object)kind)) {
                DispositionScheduleImpl schedule = new DispositionScheduleImpl(this.rmServiceRegistry, this.nodeService, nodeRef);
                if (this.getDispositionService().hasDisposableItems(schedule)) {
                    this.protectRecordLevelDispositionPropertyField(form);
                }
            }
        }
    }

    protected void addCustomPropertyFieldsToGroup(Form form, NodeRef nodeRef) {
        Set<QName> customisables = this.rmAdminService.getCustomisable(nodeRef);
        QName type = this.nodeService.getType(nodeRef);
        if (CompatibilityModel.TYPE_RECORD_SERIES.equals((Object)type)) {
            customisables.remove(TYPE_RECORD_CATEGORY);
        }
        for (QName customisable : customisables) {
            this.addPropertyFieldsToGroup(form, this.rmAdminService.getCustomPropertyDefinitions(customisable), "rm-custom", null);
        }
    }

    protected void addRecordMetadataPropertyFieldsToGroup(Form form, NodeRef nodeRef) {
        Set<QName> aspects = this.recordService.getRecordMetadataAspects(nodeRef);
        for (QName aspect : aspects) {
            if (!this.nodeService.hasAspect(nodeRef, aspect)) continue;
            String aspectName = aspect.getPrefixedQName((NamespacePrefixResolver)this.namespaceService).toPrefixString().replace(":", "-");
            String setId = "rm-metadata-" + aspectName;
            String setLabel = null;
            AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspect);
            if (aspectDefinition != null) {
                setLabel = aspectDefinition.getTitle((MessageLookup)new StaticMessageLookup());
            }
            this.addPropertyFieldsToGroup(form, this.dictionaryService.getPropertyDefs(aspect), setId, setLabel);
        }
    }

    protected void forceSupplementalMarkingListProperty(Form form, NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, RecordsManagementCustomModel.ASPECT_SUPPLEMENTAL_MARKING_LIST)) {
            PropertyDefinition propDef = this.dictionaryService.getProperty(RecordsManagementCustomModel.PROP_SUPPLEMENTAL_MARKING_LIST);
            if (propDef != null) {
                Field field = FieldUtils.makePropertyField((PropertyDefinition)propDef, null, null, (NamespaceService)this.namespaceService, (DictionaryService)this.dictionaryService);
                form.addField(field);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)("Could not add " + RecordsManagementCustomModel.PROP_SUPPLEMENTAL_MARKING_LIST.getLocalName() + " property as it's definition could not be found"));
            }
        }
    }

    protected void addTransientProperties(final Form form, final NodeRef nodeRef) {
        if (this.recordService.isRecord(nodeRef)) {
            this.addTransientPropertyField(form, TRANSIENT_DECLARED, DataTypeDefinition.BOOLEAN, this.recordService.isDeclared(nodeRef));
        }
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                DispositionSchedule ds = RecordsManagementNodeFormFilter.this.getDispositionService().getDispositionSchedule(nodeRef);
                if (ds != null) {
                    String categoryId;
                    NodeRef recordCategory;
                    String instructions = ds.getDispositionInstructions();
                    if (instructions != null) {
                        RecordsManagementNodeFormFilter.this.addTransientPropertyField(form, RecordsManagementNodeFormFilter.TRANSIENT_DISPOSITION_INSTRUCTIONS, DataTypeDefinition.TEXT, instructions);
                    }
                    if ((recordCategory = RecordsManagementNodeFormFilter.this.getDispositionService().getAssociatedRecordsManagementContainer(ds)) != null && (categoryId = (String)((Object)RecordsManagementNodeFormFilter.this.nodeService.getProperty(recordCategory, RecordsManagementModel.PROP_IDENTIFIER))) != null) {
                        RecordsManagementNodeFormFilter.this.addTransientPropertyField(form, RecordsManagementNodeFormFilter.TRANSIENT_CATEGORY_ID, DataTypeDefinition.TEXT, categoryId);
                    }
                }
                return null;
            }
        });
    }

    protected void addTransientPropertyField(Form form, String name, QName type, Object value) {
        String dataKeyName = "prop_" + name;
        PropertyFieldDefinition declaredField = new PropertyFieldDefinition(name, type.getLocalName());
        declaredField.setLabel(name);
        declaredField.setDescription(name);
        declaredField.setProtectedField(true);
        declaredField.setDataKeyName(dataKeyName);
        form.addFieldDefinition((FieldDefinition)declaredField);
        form.addData(dataKeyName, value);
    }

    protected void protectRecordProperties(Form form, NodeRef nodeRef) {
        List fieldDefs = form.getFieldDefinitions();
        for (FieldDefinition fieldDef : fieldDefs) {
            QName qname;
            if (fieldDef.isProtectedField()) continue;
            String name = fieldDef.getName();
            String prefixName = null;
            prefixName = "size".equals(name) || "mimetype".equals(name) || "encoding".equals(name) ? "cm:content" : fieldDef.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking property " + prefixName + " is editable by user " + AuthenticationUtil.getFullyAuthenticatedUser()));
            }
            if (this.recordService.isPropertyEditable(nodeRef, qname = QName.createQName((String)prefixName, (NamespacePrefixResolver)this.namespaceService))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"   ... protected property");
            }
            fieldDef.setProtectedField(true);
        }
    }

    protected void protectEmailExtractedFields(Form form, NodeRef nodeRef) {
        List fieldDefs = form.getFieldDefinitions();
        for (FieldDefinition fieldDef : fieldDefs) {
            String prefixName = fieldDef.getName();
            QName qname = QName.createQName((String)prefixName, (NamespacePrefixResolver)this.namespaceService);
            Serializable value = this.nodeService.getProperty(nodeRef, qname);
            if (value == null || !prefixName.equals("cm:title") && !prefixName.equals("cm:author") && !prefixName.equals("dod:originator") && !prefixName.equals("dod:publicationDate") && !prefixName.equals("dod:dateReceived") && !prefixName.equals("dod:address") && !prefixName.equals("dod:otherAddress")) continue;
            fieldDef.setProtectedField(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Set email related fields to be protected");
        }
    }

    protected void protectRecordLevelDispositionPropertyField(Form form) {
        List fieldDefs = form.getFieldDefinitions();
        for (FieldDefinition fieldDef : fieldDefs) {
            if (!fieldDef.getName().equals(RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION.toPrefixString((NamespacePrefixResolver)this.namespaceService))) continue;
            fieldDef.setProtectedField(true);
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Set 'rma:recordLevelDisposition' field to be protected as record folders or records are present");
        }
    }
}

