/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:recordComponentIdentifier")
public class RecordComponentIdentifierAspect
extends BaseBehaviourBean
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final String MSG_SET_ID = "rm.service.set-id";
    private static final String CONTEXT_VALUE = "rma:identifier";
    private FilePlanService filePlanService;
    private AttributeService attributeService;
    private IdentifierService identifierService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.EVERY_EVENT)
    public void onUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                String newIdValue = (String)after.get(RecordsManagementModel.PROP_IDENTIFIER);
                if (newIdValue != null) {
                    String oldIdValue = (String)before.get(RecordsManagementModel.PROP_IDENTIFIER);
                    if (oldIdValue != null && !oldIdValue.equals(newIdValue)) {
                        throw new IntegrityException(I18NUtil.getMessage((String)RecordComponentIdentifierAspect.MSG_SET_ID, (Object[])new Object[]{nodeRef.toString()}), null);
                    }
                    RecordComponentIdentifierAspect.this.updateUniqueness(nodeRef, oldIdValue, newIdValue);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.EVERY_EVENT)
    public void beforeDeleteNode(final NodeRef nodeRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                String beforeId = (String)((Object)RecordComponentIdentifierAspect.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_IDENTIFIER));
                RecordComponentIdentifierAspect.this.updateUniqueness(nodeRef, beforeId, null);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:getCopyCallback")
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new DoNothingCopyBehaviourCallback();
    }

    private void updateUniqueness(NodeRef nodeRef, String beforeId, String afterId) {
        NodeRef contextNodeRef = this.filePlanService.getFilePlan(nodeRef);
        if (beforeId == null) {
            if (afterId != null) {
                this.attributeService.createAttribute(null, new Serializable[]{CONTEXT_VALUE, contextNodeRef, afterId});
            }
        } else if (afterId == null) {
            this.attributeService.removeAttribute(new Serializable[]{CONTEXT_VALUE, contextNodeRef, beforeId});
            this.attributeService.removeAttributes(new Serializable[]{CONTEXT_VALUE, nodeRef});
        } else if (!beforeId.equals(afterId)) {
            this.attributeService.updateOrCreateAttribute((Serializable)((Object)CONTEXT_VALUE), (Serializable)contextNodeRef, (Serializable)((Object)beforeId), (Serializable)((Object)CONTEXT_VALUE), (Serializable)contextNodeRef, (Serializable)((Object)afterId));
        }
    }
}

