/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.common;

import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;

public abstract class CapabilityPatch
extends AbstractModulePatch {
    private FilePlanService filePlanService;
    private AuthorityService authorityService;
    private PermissionService permissionService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Set<NodeRef> getFilePlans() {
        return this.filePlanService.getFilePlans();
    }

    protected void addCapability(NodeRef filePlan, String capabilityName, String ... roles) {
        for (String role : roles) {
            String fullRoleName = role + filePlan.getId();
            String roleAuthority = this.authorityService.getName(AuthorityType.GROUP, fullRoleName);
            if (roleAuthority == null) {
                throw new AlfrescoRuntimeException("Role " + role + " does not exist.");
            }
            this.permissionService.setPermission(filePlan, roleAuthority, capabilityName, true);
        }
    }

    @Override
    public void applyInternal() {
        Set<NodeRef> filePlans = this.getFilePlans();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("  ... updating " + filePlans.size() + " file plans"));
        }
        for (NodeRef filePlan : filePlans) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("  ... updating file plan " + filePlan.toString()));
            }
            this.applyCapabilityPatch(filePlan);
        }
    }

    @Override
    public void apply() {
        this.setTxnReadOnly(false);
        this.setTxnRequiresNew(true);
        super.apply();
    }

    protected abstract void applyCapabilityPatch(NodeRef var1);
}

