/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bulk.hold;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkCancellationRequest;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkProcessDetails;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatus;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatusAndProcessDetails;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class DefaultHoldBulkMonitor
extends AbstractLifecycleBean
implements HoldBulkMonitor {
    protected SimpleCache<String, HoldBulkStatus> holdProgressCache;
    protected SimpleCache<String, BulkCancellationRequest> bulkCancellationsCache;
    protected SimpleCache<Pair<String, String>, HoldBulkProcessDetails> holdProcessRegistry;

    @Override
    public void updateBulkStatus(HoldBulkStatus holdBulkStatus) {
        this.holdProgressCache.put((Serializable)((Object)holdBulkStatus.bulkStatusId()), (Object)holdBulkStatus);
    }

    @Override
    public void registerProcess(NodeRef holdRef, String processId, BulkOperation bulkOperation) {
        if (holdRef != null && processId != null) {
            this.holdProcessRegistry.put((Serializable)new Pair((Object)holdRef.getId(), (Object)processId), (Object)new HoldBulkProcessDetails(processId, this.getCurrentInstanceDetails(), bulkOperation));
        }
    }

    @Override
    public HoldBulkStatus getBulkStatus(String bulkStatusId) {
        return (HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)bulkStatusId));
    }

    @Override
    public void cancelBulkOperation(String bulkStatusId, BulkCancellationRequest bulkCancellationRequest) {
        this.bulkCancellationsCache.put((Serializable)((Object)bulkStatusId), (Object)bulkCancellationRequest);
    }

    @Override
    public boolean isCancelled(String bulkStatusId) {
        return this.bulkCancellationsCache.contains((Serializable)((Object)bulkStatusId));
    }

    @Override
    public BulkCancellationRequest getBulkCancellationRequest(String bulkStatusId) {
        return (BulkCancellationRequest)this.bulkCancellationsCache.get((Serializable)((Object)bulkStatusId));
    }

    @Override
    public List<HoldBulkStatusAndProcessDetails> getBulkStatusesWithProcessDetails(String holdId) {
        return this.holdProcessRegistry.getKeys().stream().filter(holdIdAndBulkStatusId -> holdId.equals(holdIdAndBulkStatusId.getFirst())).map(holdIdAndBulkStatusId -> (HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)holdIdAndBulkStatusId)).filter(Objects::nonNull).map(this.createHoldBulkStatusAndProcessDetails()).filter(statusAndProcess -> Objects.nonNull(statusAndProcess.holdBulkStatus())).sorted(DefaultHoldBulkMonitor.sortBulkStatuses()).toList();
    }

    @Override
    public HoldBulkStatusAndProcessDetails getBulkStatusWithProcessDetails(String holdId, String bulkStatusId) {
        return Optional.ofNullable((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)holdId, (Object)bulkStatusId))).map(this.createHoldBulkStatusAndProcessDetails()).filter(statusAndProcess -> Objects.nonNull(statusAndProcess.holdBulkStatus())).orElse(null);
    }

    protected String getCurrentInstanceDetails() {
        return null;
    }

    protected Function<HoldBulkProcessDetails, HoldBulkStatusAndProcessDetails> createHoldBulkStatusAndProcessDetails() {
        return bulkProcessDetails -> new HoldBulkStatusAndProcessDetails(this.getBulkStatus(bulkProcessDetails.bulkStatusId()), (HoldBulkProcessDetails)bulkProcessDetails);
    }

    protected static Comparator<HoldBulkStatusAndProcessDetails> sortBulkStatuses() {
        return Comparator.comparing(statusAndProcess -> statusAndProcess.holdBulkStatus().endTime(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(statusAndProcess -> statusAndProcess.holdBulkStatus().startTime(), Comparator.nullsLast(Comparator.naturalOrder())).reversed();
    }

    public void setHoldProgressCache(SimpleCache<String, HoldBulkStatus> holdProgressCache) {
        this.holdProgressCache = holdProgressCache;
    }

    public void setHoldProcessRegistry(SimpleCache<Pair<String, String>, HoldBulkProcessDetails> holdProcessRegistry) {
        this.holdProcessRegistry = holdProcessRegistry;
    }

    public void setBulkCancellationsCache(SimpleCache<String, BulkCancellationRequest> bulkCancellationsCache) {
        this.bulkCancellationsCache = bulkCancellationsCache;
    }

    protected void onBootstrap(ApplicationEvent applicationEvent) {
    }

    protected void onShutdown(ApplicationEvent applicationEvent) {
    }
}

