/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionResult;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class CompleteRecordTest
extends BaseRMTestCase {
    private static final QName ASPECT_TEST = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"recordMetaDataWithProperty");
    private static final QName PROP_TEST = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"customMandatoryProperty");
    private static final QName CUSTOM_ELECTRONIC_TEST = QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmarecordCustomProperties");
    private static final QName CUSTOM_NON_ELECTRONIC_TEST = QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmanonElectronicDocumentCustomProperties");
    private static final boolean MANDATORY_METADATA = true;
    private static final boolean OPTIONAL_METADATA = false;
    private RecordServiceImpl recordServiceImpl;

    @Override
    protected void initServices() {
        super.initServices();
        this.recordServiceImpl = (RecordServiceImpl)this.applicationContext.getBean("recordService");
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
    }

    public void testCheckForMandatoryValuesMissing() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "record.txt", "title");
                CompleteRecordTest.this.nodeService.addAspect(this.record, ASPECT_TEST, null);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNotNull((Object)this.result.getValue());
                TestCase.assertFalse((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }
        });
    }

    public void testCheckForMandatoryValuePresent() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "record.txt", "title");
                HashMap<QName, String> properties = new HashMap<QName, String>(1);
                properties.put(PROP_TEST, "something");
                CompleteRecordTest.this.nodeService.addAspect(this.record, ASPECT_TEST, properties);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }
        });
    }

    public void testCheckForCustomMandatoryValuesMissing() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_ELECTRONIC_TEST, RecordsManagementModel.ASPECT_RECORD, true);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "electronicRecord.txt", "title");
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNotNull((Object)this.result.getValue());
                TestCase.assertFalse((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_ELECTRONIC_TEST);
            }
        });
    }

    public void testCheckForCustomMandatoryValuePresent() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_ELECTRONIC_TEST, RecordsManagementModel.ASPECT_RECORD, true);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "customrecord.txt", "title");
                CompleteRecordTest.this.populateCustomMetadata(this.record, CUSTOM_ELECTRONIC_TEST);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_ELECTRONIC_TEST);
            }
        });
    }

    public void testCheckForCustomMandatoryValuesMissingInNonElectronicRecord() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef nonElectronicRecord;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST, RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT, true);
                this.nonElectronicRecord = CompleteRecordTest.this.utils.createNonElectronicRecord(CompleteRecordTest.this.rmFolder, "non-electronicRecord.txt", "title");
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.nonElectronicRecord, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNotNull((Object)this.result.getValue());
                TestCase.assertFalse((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.nonElectronicRecord, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST);
            }
        });
    }

    public void testCheckForCustomMandatoryValuePresentInNonElectronicRecord() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef nonElectronicRecord;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST, RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT, true);
                this.nonElectronicRecord = CompleteRecordTest.this.utils.createNonElectronicRecord(CompleteRecordTest.this.rmFolder, "non-electronicRecord.txt", "title");
                CompleteRecordTest.this.populateCustomMetadata(this.nonElectronicRecord, CUSTOM_NON_ELECTRONIC_TEST);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.nonElectronicRecord, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.nonElectronicRecord, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST);
            }
        });
    }

    public void testCheckForCustomOptionalValuesMissing() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_ELECTRONIC_TEST, RecordsManagementModel.ASPECT_RECORD, false);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "customrecord.txt", "title");
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_ELECTRONIC_TEST);
            }
        });
    }

    public void testElectronicRecordCustomMandatoryNotAppliedToNonElectronicRecord() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef nonElectronicRecord;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_ELECTRONIC_TEST, RecordsManagementModel.ASPECT_RECORD, true);
                this.nonElectronicRecord = CompleteRecordTest.this.utils.createNonElectronicRecord(CompleteRecordTest.this.rmFolder, "non-electronicRecord.txt", "title");
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.nonElectronicRecord, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.nonElectronicRecord, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_ELECTRONIC_TEST);
            }
        });
    }

    public void testNonElectronicRecordCustomMandatoryNotAppliedToElectronicRecord() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() throws Exception {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(true);
                CompleteRecordTest.this.defineCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST, RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT, true);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "electronicRecord.txt", "title");
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }

            @Override
            public void after() {
                CompleteRecordTest.this.removeCustomMetadata(CUSTOM_NON_ELECTRONIC_TEST);
            }
        });
    }

    public void testDontCheckForMandatoryValuesMissing() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(false);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "record.txt", "title");
                CompleteRecordTest.this.nodeService.addAspect(this.record, ASPECT_TEST, null);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }
        });
    }

    public void testDontCheckForMandatoryValuePresent() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef record;
            private RecordsManagementActionResult result;

            @Override
            public void given() {
                CompleteRecordTest.this.recordServiceImpl.setCheckMandatoryPropertiesEnabled(false);
                this.record = CompleteRecordTest.this.utils.createRecord(CompleteRecordTest.this.rmFolder, "record.txt", "title");
                HashMap<QName, String> properties = new HashMap<QName, String>(1);
                properties.put(PROP_TEST, "something");
                CompleteRecordTest.this.nodeService.addAspect(this.record, ASPECT_TEST, properties);
            }

            @Override
            public void when() {
                this.result = CompleteRecordTest.this.rmActionService.executeRecordsManagementAction(this.record, "declareRecord");
            }

            @Override
            public void then() {
                TestCase.assertNotNull((Object)this.result);
                TestCase.assertNull((Object)this.result.getValue());
                TestCase.assertTrue((boolean)CompleteRecordTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DECLARED_RECORD));
            }
        });
    }

    private void defineCustomMetadata(QName propId, QName typeName, boolean mandatory) throws Exception {
        this.rmAdminService.addCustomPropertyDefinition(propId, typeName, "SomeCustomDefLabel", DataTypeDefinition.TEXT, null, null, null, false, mandatory, false, null);
    }

    private void populateCustomMetadata(NodeRef record, QName propId) {
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(propId, "SomeCustomValue");
        this.nodeService.addAspect(record, propId, properties);
    }

    private void removeCustomMetadata(QName propId) {
        this.rmAdminService.removeCustomPropertyDefinition(propId);
    }
}

