/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.io.IOException;
import org.alfresco.module.org_alfresco_module_rm.test.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionUtilsUsageExamplesUnitTest {
    private String goodMethod() {
        return "hello";
    }

    private String badMethod1() {
        throw new RuntimeException("Bad method");
    }

    private String badMethod2() {
        throw new UnsupportedOperationException("Bad method", new RuntimeException("root cause"));
    }

    @Test
    public void swallowExpectedExceptions() {
        ExceptionUtils.expectedException(RuntimeException.class, () -> this.badMethod1());
        ExceptionUtils.expectedException(RuntimeException.class, () -> {
            for (int i = 0; i < 10; ++i) {
                this.goodMethod();
            }
            this.badMethod2();
            return null;
        });
    }

    @Test
    public void examineTheExpectedException() {
        UnsupportedOperationException e = ExceptionUtils.expectedException(UnsupportedOperationException.class, () -> this.badMethod2());
        Assert.assertEquals(RuntimeException.class, e.getCause().getClass());
    }

    @Test(expected=ExceptionUtils.MissingThrowableException.class)
    public void expectedExceptionNotThrown() {
        ExceptionUtils.expectedException(IOException.class, () -> null);
    }

    @Test(expected=ExceptionUtils.UnexpectedThrowableException.class)
    public void unexpectedExceptionThrown() {
        ExceptionUtils.expectedException(IOException.class, () -> {
            throw new UnsupportedOperationException();
        });
    }

    private void onlySideEffectsHere() {
        throw new IllegalStateException();
    }

    private void onlySideEffectsHere(String s) {
        throw new IllegalStateException();
    }

    @Test
    public void usingVoidLambdas() {
        ExceptionUtils.expectedException(IllegalStateException.class, () -> {
            this.onlySideEffectsHere();
            return null;
        });
        ExceptionUtils.expectedException(IllegalStateException.class, () -> {
            this.onlySideEffectsHere("hello");
            return null;
        });
    }

    @Test
    public void smuggleCheckedExceptionsShouldHideCheckedExceptionsInAnUncheckedException() {
        ExceptionUtils.SmuggledException e = ExceptionUtils.expectedException(ExceptionUtils.SmuggledException.class, () -> ExceptionUtils.smuggleCheckedExceptions(() -> this.methodThrowsException()));
        Assert.assertEquals(Exception.class, e.getCheckedException().getClass());
        Assert.assertEquals((Object)"Checked", (Object)e.getCheckedException().getMessage());
    }

    private Object methodThrowsException() throws Exception {
        throw new Exception("Checked");
    }
}

