/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.vote.AccessDecisionVoter;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.capability.PolicyRegister;
import org.alfresco.module.org_alfresco_module_rm.capability.RMSecurityCommon;
import org.alfresco.module.org_alfresco_module_rm.capability.policy.ConfigAttributeDefinition;
import org.alfresco.module.org_alfresco_module_rm.capability.policy.Policy;
import org.alfresco.module.org_alfresco_module_rm.security.RMMethodSecurityInterceptor;
import org.alfresco.module.org_alfresco_module_rm.util.AlfrescoTransactionSupport;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RMEntryVoter
extends RMSecurityCommon
implements AccessDecisionVoter,
InitializingBean,
PolicyRegister {
    private static Log logger = LogFactory.getLog(RMEntryVoter.class);
    private NamespacePrefixResolver nspr;
    private CapabilityService capabilityService;
    private TransactionalResourceHelper transactionalResourceHelper;
    private AlfrescoTransactionSupport alfrescoTransactionSupport;
    private AuthenticationUtil authenticationUtil;
    private Map<String, Policy> policies = new HashMap<String, Policy>();

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public void setTransactionalResourceHelper(TransactionalResourceHelper transactionalResourceHelper) {
        this.transactionalResourceHelper = transactionalResourceHelper;
    }

    public void setAlfrescoTransactionSupport(AlfrescoTransactionSupport alfrescoTransactionSupport) {
        this.alfrescoTransactionSupport = alfrescoTransactionSupport;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    @Override
    public void registerPolicy(Policy policy) {
        this.policies.put(policy.getName(), policy);
    }

    public boolean supports(ConfigAttribute configAttribute) {
        boolean supports = false;
        String attribute = configAttribute.getAttribute();
        if (StringUtils.isNotBlank((CharSequence)attribute) && (attribute.equals("RM_ABSTAIN") || attribute.equals("RM_QUERY") || attribute.equals("RM_ALLOW") || attribute.equals("RM_DENY") || attribute.startsWith("RM_CAP") || attribute.startsWith("RM"))) {
            supports = true;
        }
        return supports;
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int vote(Authentication authentication, Object object, net.sf.acegisecurity.ConfigAttributeDefinition config) {
        RMMethodSecurityInterceptor.isRMSecurityChecked(true);
        MethodInvocation mi = (MethodInvocation)object;
        if (this.transactionalResourceHelper.isResourcePresent("voting")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" .. grant access already voting: " + mi.getMethod().getDeclaringClass().getName() + "." + mi.getMethod().getName()));
            }
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Method: " + mi.getMethod().getDeclaringClass().getName() + "." + mi.getMethod().getName()));
        }
        this.alfrescoTransactionSupport.bindResource("voting", true);
        try {
            if (this.authenticationUtil.isRunAsUserTheSystemUser()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access granted for the system user");
                }
                int n = 1;
                return n;
            }
            List<ConfigAttributeDefinition> supportedDefinitions = this.extractSupportedDefinitions(config);
            if (supportedDefinitions.size() == 0) {
                int n = 0;
                return n;
            }
            if (!(object instanceof MethodInvocation)) {
                throw new AlfrescoRuntimeException("Passed object is not an instance of MethodInvocation as expected.");
            }
            MethodInvocation invocation = (MethodInvocation)object;
            Method method = invocation.getMethod();
            Class[] params = method.getParameterTypes();
            block23: for (ConfigAttributeDefinition cad : supportedDefinitions) {
                if (cad.getTypeString().equals("RM_DENY")) {
                    RMMethodSecurityInterceptor.addMessage("RM_DENY: check that a security policy has been set for this method");
                    int n = -1;
                    return n;
                }
                if (cad.getTypeString().equals("RM_ABSTAIN")) {
                    int n = 0;
                    return n;
                }
                if (cad.getTypeString().equals("RM_ALLOW")) {
                    int n = 1;
                    return n;
                }
                if (cad.getTypeString().equals("RM_QUERY")) {
                    int n = 1;
                    return n;
                }
                if (cad.getParameters().get(0) != null && cad.getParameters().get(0) >= invocation.getArguments().length || cad.getParameters().get(1) != null && cad.getParameters().get(1) >= invocation.getArguments().length) continue;
                if (cad.getTypeString().equals("RM_CAP")) {
                    switch (this.checkCapability(invocation, params, cad)) {
                        case -1: {
                            int n = -1;
                            return n;
                        }
                        case 0: {
                            if (logger.isDebugEnabled()) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("Capability " + String.valueOf(cad.getRequired()) + " abstained for " + String.valueOf(invocation.getMethod())), (Throwable)new IllegalStateException());
                                } else {
                                    logger.debug((Object)("Capability " + String.valueOf(cad.getRequired()) + " abstained for " + String.valueOf(invocation.getMethod())));
                                }
                            }
                            int n = -1;
                            return n;
                        }
                        case 1: {
                            continue block23;
                        }
                    }
                    continue;
                }
                if (!cad.getTypeString().equals("RM")) continue;
                switch (this.checkPolicy(invocation, params, cad)) {
                    case -1: {
                        RMMethodSecurityInterceptor.addMessage("Policy " + cad.getPolicyName() + " denied.");
                        int n = -1;
                        return n;
                    }
                    case 0: {
                        if (logger.isDebugEnabled()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Policy " + cad.getPolicyName() + " abstained for " + String.valueOf(invocation.getMethod())), (Throwable)new IllegalStateException());
                            } else {
                                logger.debug((Object)("Policy " + cad.getPolicyName() + " abstained for " + String.valueOf(invocation.getMethod())));
                            }
                        }
                        int n = -1;
                        return n;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        }
        finally {
            this.alfrescoTransactionSupport.unbindResource("voting");
        }
        return 1;
    }

    private int checkCapability(MethodInvocation invocation, Class[] params, ConfigAttributeDefinition cad) {
        NodeRef testNodeRef = this.getTestNode(invocation, params, cad.getParameters().get(0), cad.isParent());
        if (testNodeRef == null) {
            return 0;
        }
        Capability capability = this.capabilityService.getCapability(cad.getRequired().getName());
        if (capability == null) {
            throw new AlfrescoRuntimeException("The capability '" + cad.getRequired().getName() + "' set on method '" + invocation.getMethod().getName() + "' does not exist.");
        }
        return capability.hasPermissionRaw(testNodeRef);
    }

    private int checkPolicy(MethodInvocation invocation, Class[] params, ConfigAttributeDefinition cad) {
        Policy policy = this.policies.get(cad.getPolicyName());
        if (policy == null) {
            throw new AlfrescoRuntimeException("The policy '" + cad.getPolicyName() + "' set on the method '" + invocation.getMethod().getName() + "' does not exist.");
        }
        return policy.evaluate(invocation, params, cad);
    }

    public void afterPropertiesSet() {
    }

    private List<ConfigAttributeDefinition> extractSupportedDefinitions(net.sf.acegisecurity.ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefinition> definitions = new ArrayList<ConfigAttributeDefinition>(2);
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefinition(attr, this.nspr));
        }
        return definitions;
    }
}

