/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.ObjectUtils;

public final class RMCollectionUtils {
    private RMCollectionUtils() {
    }

    public static <T> List<T> getDuplicateElements(List<T> l) {
        HashSet<T> uniqueElems = new HashSet<T>();
        ArrayList<T> duplicateElems = new ArrayList<T>();
        for (T elem : l) {
            if (uniqueElems.contains(elem)) {
                if (duplicateElems.contains(elem)) continue;
                duplicateElems.add(elem);
                continue;
            }
            uniqueElems.add(elem);
        }
        return duplicateElems;
    }

    public static <T> T head(List<T> l) {
        return l.isEmpty() ? null : (T)l.get(0);
    }

    public static <T> List<T> tail(List<T> l) {
        if (l.isEmpty()) {
            throw new UnsupportedOperationException("Cannot get tail of empty list.");
        }
        return l.subList(1, l.size());
    }

    @SafeVarargs
    public static <T extends Serializable, LIST extends Serializable & List<T>> LIST asSerializableList(T ... elements) {
        ArrayList l = new ArrayList(elements.length);
        for (T element : elements) {
            ((List)l).add(element);
        }
        return (LIST)l;
    }

    @SafeVarargs
    public static <T> HashSet<T> asSet(T ... elements) {
        HashSet<T> set = new HashSet<T>(elements.length);
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T> HashSet<T> asSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <K, V> Difference diffKey(Map<K, V> from, Map<K, V> to, K key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (from.containsKey(key)) {
            if (to.containsKey(key)) {
                if (ObjectUtils.nullSafeEquals(from.get(key), to.get(key))) {
                    return Difference.UNCHANGED;
                }
                return Difference.CHANGED;
            }
            return Difference.REMOVED;
        }
        if (to.containsKey(key)) {
            return Difference.ADDED;
        }
        return Difference.UNCHANGED;
    }

    public static <T> ImmutableSet<T> toImmutableSet(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.contains(null)) {
            collection = new HashSet<T>(collection);
            collection.remove(null);
        }
        return ImmutableSet.copyOf(collection);
    }

    public static boolean isEmpty(Serializable value) {
        if (value instanceof Collection) {
            return CollectionUtils.isEmpty((Collection)((Collection)((Object)value)));
        }
        return value == null;
    }

    public static enum Difference {
        ADDED,
        REMOVED,
        CHANGED,
        UNCHANGED;

    }
}

