/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.capability.AbstractCapability;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.declarative.CapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.security.RMMethodSecurityInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeclarativeCapability
extends AbstractCapability {
    protected static final Log LOGGER = LogFactory.getLog(DeclarativeCapability.class);
    protected List<String> permissions;
    protected Map<String, Boolean> conditions;
    protected List<String> kinds;
    protected Capability targetCapability;
    protected boolean isUndetermined = false;
    private Set<FilePlanComponentKind> availableKinds;

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setConditions(Map<String, Boolean> conditions) {
        this.conditions = conditions;
    }

    public Map<String, Boolean> getConditions() {
        return this.conditions;
    }

    public void setKinds(List<String> kinds) {
        this.kinds = kinds;
    }

    public List<String> getKinds() {
        return this.kinds;
    }

    public void setKind(String kind) {
        this.kinds = Collections.singletonList(kind);
    }

    public void setUndetermined(boolean isUndetermined) {
        this.isUndetermined = isUndetermined;
    }

    public boolean isUndetermined() {
        return this.isUndetermined;
    }

    public void setPermission(String permission) {
        ArrayList<String> permissions = new ArrayList<String>(1);
        permissions.add(permission);
        this.permissions = permissions;
    }

    public void setTargetCapability(Capability targetCapability) {
        this.targetCapability = targetCapability;
    }

    protected boolean checkPermissionsImpl(NodeRef nodeRef, String ... permissions) {
        boolean result = true;
        NodeRef filePlan = this.getFilePlanService().getFilePlan(nodeRef);
        if (filePlan == null) {
            return result;
        }
        for (String permission : permissions) {
            if (this.permissionService.hasPermission(filePlan, permission) == AccessStatus.ALLOWED) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean checkPermissions(NodeRef nodeRef) {
        boolean result = true;
        if (this.permissions != null && !this.permissions.isEmpty()) {
            result = this.checkPermissionsImpl(nodeRef, this.permissions.toArray(new String[this.permissions.size()]));
        }
        return result;
    }

    protected boolean checkConditions(NodeRef nodeRef, Map<String, Boolean> conditions) {
        boolean result = true;
        if (conditions != null) {
            for (Map.Entry<String, Boolean> entry : conditions.entrySet()) {
                boolean expected = entry.getValue();
                String conditionName = entry.getKey();
                CapabilityCondition condition = (CapabilityCondition)this.applicationContext.getBean(conditionName);
                if (condition == null) {
                    throw new AlfrescoRuntimeException("Capability condition " + conditionName + " does not exist.  Check the configuration of the capability " + this.name + ".");
                }
                boolean actual = condition.evaluate(nodeRef);
                RMMethodSecurityInterceptor.reportCapabilityCondition(this.getName(), condition.getName(), expected, actual);
                if (expected == actual) continue;
                result = false;
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)("FAIL: Condition " + condition.getName() + " failed for capability " + this.getName() + " on nodeRef " + nodeRef.toString()));
                break;
            }
        }
        return result;
    }

    protected boolean checkConditions(NodeRef nodeRef) {
        return this.checkConditions(nodeRef, this.conditions);
    }

    private Set<FilePlanComponentKind> getAvailableKinds() {
        if (this.kinds != null && this.availableKinds == null) {
            this.availableKinds = new HashSet<FilePlanComponentKind>(this.kinds.size());
            for (String kindString : this.kinds) {
                FilePlanComponentKind kind = FilePlanComponentKind.valueOf(kindString);
                this.availableKinds.add(kind);
            }
        }
        return this.availableKinds;
    }

    protected boolean checkKinds(NodeRef nodeRef) {
        Set<FilePlanComponentKind> availableKinds;
        boolean result = false;
        FilePlanComponentKind actualKind = this.getFilePlanService().getFilePlanComponentKind(nodeRef);
        if (actualKind != null && ((availableKinds = this.getAvailableKinds()) == null || availableKinds.contains((Object)actualKind))) {
            result = true;
        }
        return result;
    }

    @Override
    public int evaluate(NodeRef nodeRef) {
        String key;
        int result = 0;
        Map map = TransactionalResourceHelper.getMap((Object)"rm.declarativeCapability");
        if (map.containsKey(key = this.getName() + "|" + nodeRef.toString() + "|" + AuthenticationUtil.getRunAsUser())) {
            result = (Integer)map.get(key);
        } else {
            if (this.getFilePlanService().isFilePlanComponent(nodeRef)) {
                result = this.checkKinds(nodeRef) && this.checkPermissions(nodeRef) && this.checkConditions(nodeRef) ? this.evaluateImpl(nodeRef) : -1;
            }
            result = this.onEvaluate(nodeRef, result);
            if (LOGGER.isDebugEnabled() && -1 == result) {
                LOGGER.debug((Object)("Capability " + this.getName() + " returned an Access Denied result during evaluation of node " + nodeRef.toString()));
            }
            map.put(key, result);
        }
        return result;
    }

    @Override
    public int evaluate(NodeRef source, NodeRef target) {
        int result = this.evaluate(source);
        if (this.targetCapability != null && result != -1) {
            result = this.targetCapability.evaluate(target);
        }
        return result;
    }

    protected int evaluateImpl(NodeRef nodeRef) {
        int result = 1;
        if (this.isUndetermined) {
            result = 0;
        }
        return result;
    }

    protected int onEvaluate(NodeRef nodeRef, int result) {
        return result;
    }
}

