/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.repo.version.Node2ServiceImpl;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class RecordableVersionNodeServiceImpl
extends Node2ServiceImpl
implements RecordableVersionModel {
    private RecordService recordService;
    private List<String> recordModelURIs;

    public void setRecordModelURIs(List<String> recordModelURIs) {
        this.recordModelURIs = recordModelURIs;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        NodeRef converted = VersionUtil.convertNodeRef((NodeRef)nodeRef);
        if (this.dbNodeService.hasAspect(converted, ASPECT_RECORDED_VERSION)) {
            NodeRef record = (NodeRef)this.dbNodeService.getProperty(converted, PROP_RECORD_NODE_REF);
            if (record != null && this.dbNodeService.exists(record)) {
                Map properties = this.dbNodeService.getProperties(record);
                return this.processProperties(converted, properties);
            }
            return Collections.EMPTY_MAP;
        }
        return super.getProperties(nodeRef);
    }

    protected Map<QName, Serializable> processProperties(NodeRef version, Map<QName, Serializable> properties) {
        HashMap<QName, Serializable> cloneProperties = new HashMap<QName, Serializable>(properties);
        properties.put(ContentModel.PROP_NAME, properties.get(RecordsManagementModel.PROP_ORIGIONAL_NAME));
        for (QName property : cloneProperties.keySet()) {
            if (PROP_RECORDABLE_VERSION_POLICY.equals((Object)property) || PROP_FILE_PLAN.equals((Object)property) || !this.recordService.isRecordMetadataProperty(property) && !this.recordModelURIs.contains(property.getNamespaceURI())) continue;
            properties.remove(property);
        }
        this.processVersionProperties(version, properties);
        return properties;
    }

    protected void processVersionProperties(NodeRef version, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Map versionProperties = this.dbNodeService.getProperties(version);
        if (versionProperties != null) {
            String owner;
            Date accessed;
            Date modified;
            String modifier;
            Date created;
            String versionLabel = (String)versionProperties.get(Version2Model.PROP_QNAME_VERSION_LABEL);
            properties.put(ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)versionLabel));
            NodeRef nodeRef = (NodeRef)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_NODE_REF);
            if (nodeRef != null) {
                properties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
                properties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
                properties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)nodeRef.getId()));
            }
            Long dbid = (Long)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_NODE_DBID);
            properties.put(ContentModel.PROP_NODE_DBID, dbid);
            String creator = (String)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_CREATOR);
            if (creator != null) {
                properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)creator));
            }
            if ((created = (Date)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_CREATED)) != null) {
                properties.put(ContentModel.PROP_CREATED, created);
            }
            if ((modifier = (String)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_MODIFIER)) != null) {
                properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)modifier));
            }
            if ((modified = (Date)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_MODIFIED)) != null) {
                properties.put(ContentModel.PROP_MODIFIED, modified);
            }
            if ((accessed = (Date)versionProperties.get(Version2Model.PROP_QNAME_FROZEN_ACCESSED)) != null) {
                properties.put(ContentModel.PROP_ACCESSED, accessed);
            }
            if ((owner = (String)versionProperties.get(PROP_FROZEN_OWNER)) != null) {
                properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)owner));
            }
        }
    }

    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        NodeRef converted = VersionUtil.convertNodeRef((NodeRef)nodeRef);
        if (this.dbNodeService.hasAspect(converted, ASPECT_RECORDED_VERSION)) {
            NodeRef record = (NodeRef)this.dbNodeService.getProperty(converted, PROP_RECORD_NODE_REF);
            if (record != null && this.dbNodeService.exists(record)) {
                Set aspects = this.dbNodeService.getAspects(record);
                return this.processAspects(aspects);
            }
            return Collections.EMPTY_SET;
        }
        return super.getAspects(nodeRef);
    }

    protected Set<QName> processAspects(Set<QName> aspects) {
        HashSet<QName> result = new HashSet<QName>(aspects);
        result.remove(ASPECT_VERSION);
        result.remove(ASPECT_RECORDED_VERSION);
        for (QName aspect : aspects) {
            if (ASPECT_VERSIONABLE.equals((Object)aspect) || !this.recordService.isRecordMetadataAspect(aspect) && !this.recordModelURIs.contains(aspect.getNamespaceURI())) continue;
            result.remove(aspect);
        }
        return result;
    }
}

