/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.unfiledcontainers;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.UnfiledContainer;
import org.alfresco.rm.rest.api.model.UnfiledContainerChild;
import org.alfresco.rm.rest.api.model.UploadInfo;
import org.alfresco.rm.rest.api.unfiledcontainers.UnfiledContainerEntityResource;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="children", entityResource=UnfiledContainerEntityResource.class, title="Children of an unfiled container")
public class UnfiledContainerChildrenRelation
implements RelationshipResourceAction.Read<UnfiledContainerChild>,
RelationshipResourceAction.Create<UnfiledContainerChild>,
MultiPartRelationshipResourceAction.Create<UnfiledContainerChild> {
    private static final Set<String> LIST_UNFILED_CONTAINER_CHILDREN_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("isUnfiledRecordFolder", "isRecord", "nodeType"));
    private FilePlanComponentsApiUtils apiUtils;
    private SearchTypesFactory searchTypesFactory;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @WebApiDescription(title="Return a paged list of unfiled container children for the container identified by 'unfiledContainerId'")
    public CollectionWithPagingInfo<UnfiledContainerChild> readAll(String unfiledContainerId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledContainerId", unfiledContainerId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledContainerId, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        Set<QName> searchTypeQNames = this.searchTypesFactory.buildSearchTypesForUnfiledEndpoint(parameters, LIST_UNFILED_CONTAINER_CHILDREN_EQUALS_QUERY_PROPERTIES);
        List<FilterProp> filterProps = this.apiUtils.getListChildrenFilterProps(parameters, LIST_UNFILED_CONTAINER_CHILDREN_EQUALS_QUERY_PROPERTIES);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, null, searchTypeQNames, null, this.apiUtils.getSortProperties(parameters), filterProps, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<UnfiledContainerChild> nodes = new AbstractList<UnfiledContainerChild>(){

            @Override
            public UnfiledContainerChild get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return UnfiledContainerChildrenRelation.this.nodesModelFactory.createUnfiledContainerChild(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        UnfiledContainer sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createUnfiledContainer(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }

    @WebApiDescription(title="Create one (or more) nodes as children of a unfiled container identified by 'unfiledContainerId'")
    public List<UnfiledContainerChild> create(String unfiledContainerId, final List<UnfiledContainerChild> nodeInfos, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledContainerId", unfiledContainerId);
        ParameterCheck.mandatory((String)"nodeInfos", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledContainerId, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() {
                LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
                for (UnfiledContainerChild nodeInfo : nodeInfos) {
                    NodeRef newNodeRef = UnfiledContainerChildrenRelation.this.apiUtils.createRMNode(parentNodeRef, nodeInfo, parameters);
                    createdNodes.add(newNodeRef);
                }
                return createdNodes;
            }
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        LinkedList<UnfiledContainerChild> result = new LinkedList<UnfiledContainerChild>();
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        for (NodeRef newNodeRef : createdNodes) {
            FileInfo info = this.fileFolderService.getFileInfo(newNodeRef);
            this.apiUtils.postActivity(info, parentNodeRef, "org.alfresco.documentlibrary.file-added");
            result.add(this.nodesModelFactory.createUnfiledContainerChild(info, parameters, mapUserInfo, false));
        }
        return result;
    }

    @WebApiDescription(title="Upload file content and meta-data into a unfiled record container identified by 'unfiledContainerId'.")
    @WebApiParam(name="formData", title="A single form data", description="A single form data which holds FormFields.")
    public UnfiledContainerChild create(String unfiledContainerId, FormData formData, final Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("unfiledContainerId", unfiledContainerId);
        ParameterCheck.mandatory((String)"formData", (Object)formData);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final UploadInfo uploadInfo = new UploadInfo(formData);
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledContainerId, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                return UnfiledContainerChildrenRelation.this.apiUtils.uploadRecord(parentNodeRef, uploadInfo, parameters);
            }
        };
        NodeRef newNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        FileInfo info = this.fileFolderService.getFileInfo(newNode);
        this.apiUtils.postActivity(info, parentNodeRef, "org.alfresco.documentlibrary.file-added");
        return this.nodesModelFactory.createUnfiledContainerChild(info, parameters, null, false);
    }
}

