/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.repo.action.ActionServiceImpl;
import org.alfresco.repo.action.evaluator.ActionConditionEvaluator;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ExtendedActionServiceImpl
extends ActionServiceImpl
implements ApplicationContextAware {
    private FilePlanService filePlanService;
    private ApplicationContext extendedApplicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
        this.extendedApplicationContext = applicationContext;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public ActionConditionDefinition getActionConditionDefinition(String name) {
        ActionConditionDefinition definition = null;
        Object bean = this.extendedApplicationContext.getBean(name);
        if (bean instanceof ActionConditionEvaluator) {
            ActionConditionEvaluator evaluator = (ActionConditionEvaluator)bean;
            definition = evaluator.getActionConditionDefintion();
        }
        return definition;
    }

    public List<ActionDefinition> getActionDefinitions(NodeRef nodeRef) {
        ArrayList<ActionDefinition> result = null;
        ArrayList<ActionDefinition> actionDefinitions = super.getActionDefinitions(nodeRef);
        if (nodeRef == null) {
            result = actionDefinitions;
        } else {
            FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRef);
            result = new ArrayList<ActionDefinition>(actionDefinitions.size());
            for (ActionDefinition actionDefinition : actionDefinitions) {
                if (actionDefinition instanceof RecordsManagementActionDefinition) {
                    Set<FilePlanComponentKind> applicableKinds;
                    if (kind == null || (applicableKinds = ((RecordsManagementActionDefinition)actionDefinition).getApplicableKinds()) != null && applicableKinds.size() != 0 && !applicableKinds.contains((Object)kind)) continue;
                    result.add(actionDefinition);
                    continue;
                }
                if (kind != null) continue;
                result.add(actionDefinition);
            }
        }
        return result;
    }
}

