/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.report;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.report.Report;
import org.alfresco.module.org_alfresco_module_rm.report.ReportGenerator;
import org.alfresco.module.org_alfresco_module_rm.report.ReportService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ReportServiceImpl
extends ServiceBaseImpl
implements ReportService {
    protected RecordService recordService;
    private Map<QName, ReportGenerator> registry = new HashMap<QName, ReportGenerator>();

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    @Override
    public void registerReportGenerator(ReportGenerator reportGenerator) {
        ParameterCheck.mandatory((String)"reportGenerator", (Object)reportGenerator);
        this.registry.put(reportGenerator.getReportType(), reportGenerator);
    }

    @Override
    public Set<QName> getReportTypes() {
        return this.registry.keySet();
    }

    @Override
    public Report generateReport(QName reportType, NodeRef reportedUponNodeRef) {
        ParameterCheck.mandatory((String)"reportType", (Object)reportType);
        ParameterCheck.mandatory((String)"reportedUponNodeRef", (Object)reportedUponNodeRef);
        return this.generateReport(reportType, reportedUponNodeRef, "text/html");
    }

    @Override
    public Report generateReport(QName reportType, NodeRef reportedUponNodeRef, String mimetype) {
        ParameterCheck.mandatory((String)"reportType", (Object)reportType);
        ParameterCheck.mandatory((String)"reportedUponNodeRef", (Object)reportedUponNodeRef);
        ParameterCheck.mandatoryString((String)"mimetype", (String)mimetype);
        ReportGenerator generator = this.registry.get(reportType);
        if (generator == null) {
            throw new AlfrescoRuntimeException("Unable to generate report, because report type " + reportType.toString() + " does not correspond to a registered report type.");
        }
        return generator.generateReport(reportedUponNodeRef, mimetype);
    }

    @Override
    public NodeRef fileReport(NodeRef nodeRef, Report report) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"report", (Object)report);
        return this.recordService.createRecordFromContent(nodeRef, report.getReportName(), report.getReportType(), report.getReportProperties(), report.getReportContent());
    }
}

