/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.role;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.bootstrap.BootstrapImporterModuleComponent;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.util.FileUtils;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FilePlanRoleServiceImpl
implements FilePlanRoleService,
RecordsManagementModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePlanRoleServiceImpl.class);
    private static final String MSG_ALL_ROLES = "rm.role.all";
    private static final String BOOTSTRAP_ROLE_JSON_LOCATION = "alfresco/module/org_alfresco_module_rm/security/rm-default-roles-bootstrap.json";
    private static final String JSON_NAME = "name";
    private static final String JSON_DISPLAY_LABEL = "displayLabel";
    private static final String JSON_IS_ADMIN = "isAdmin";
    private static final String JSON_CAPABILITIES = "capabilities";
    private CapabilityService capabilityService;
    private AuthorityService authorityService;
    private PermissionService permissionService;
    private FilePlanService filePlanService;
    private NodeService nodeService;
    private BootstrapImporterModuleComponent bootstrapImporterModule;
    public static final String RM_ROLE_ZONE_PREFIX = "rmRoleZone";
    private static final String CONFIG_NODEID = "rm_config_folder";

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setBootstrapImporterModuleComponent(BootstrapImporterModuleComponent bootstrapImporterModuleComponent) {
        this.bootstrapImporterModule = bootstrapImporterModuleComponent;
    }

    @Override
    public void setupFilePlanRoles(final NodeRef filePlan) {
        if (filePlan.getStoreRef().equals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) {
            return;
        }
        if (this.nodeService.exists(filePlan)) {
            List systemContainers = (List)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<NodeRef>>(){

                public List<NodeRef> doWork() {
                    ArrayList<NodeRef> systemContainers = new ArrayList<NodeRef>(3);
                    NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, FilePlanRoleServiceImpl.CONFIG_NODEID);
                    if (!FilePlanRoleServiceImpl.this.nodeService.exists(nodeRef)) {
                        FilePlanRoleServiceImpl.this.bootstrapImporterModule.execute();
                    }
                    String allRoles = FilePlanRoleServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getAllRolesGroupShortName(filePlan), I18NUtil.getMessage((String)FilePlanRoleServiceImpl.MSG_ALL_ROLES), new HashSet<String>(Arrays.asList("APP.RM")));
                    FilePlanRoleServiceImpl.this.permissionService.setInheritParentPermissions(filePlan, false);
                    FilePlanRoleServiceImpl.this.permissionService.setPermission(filePlan, allRoles, "ReadRecords", true);
                    systemContainers.add(FilePlanRoleServiceImpl.this.filePlanService.createHoldContainer(filePlan));
                    systemContainers.add(FilePlanRoleServiceImpl.this.filePlanService.createTransferContainer(filePlan));
                    systemContainers.add(FilePlanRoleServiceImpl.this.filePlanService.createUnfiledContainer(filePlan));
                    return systemContainers;
                }
            });
            this.bootstrapDefaultRoles(filePlan, systemContainers);
        }
    }

    @Override
    public void tearDownFilePlanRoles(final NodeRef filePlan) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                String allRolesGroup = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getAllRolesGroupShortName(filePlan));
                Set groups = FilePlanRoleServiceImpl.this.authorityService.getContainedAuthorities(AuthorityType.GROUP, allRolesGroup, true);
                for (String group : groups) {
                    FilePlanRoleServiceImpl.this.authorityService.deleteAuthority(group);
                }
                FilePlanRoleServiceImpl.this.authorityService.deleteAuthority(allRolesGroup, false);
                return null;
            }
        });
    }

    private String getAllRolesGroupShortName(NodeRef rmRootNode) {
        return "AllRoles" + rmRootNode.getId();
    }

    private void bootstrapDefaultRoles(final NodeRef filePlan, final List<NodeRef> systemContainers) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                try {
                    JSONArray array = null;
                    try {
                        InputStream is = this.getClass().getClassLoader().getResourceAsStream(FilePlanRoleServiceImpl.BOOTSTRAP_ROLE_JSON_LOCATION);
                        if (is == null) {
                            throw new AlfrescoRuntimeException("Could not load default bootstrap roles configuration");
                        }
                        array = new JSONArray(FileUtils.convertStreamToString(is));
                    }
                    catch (IOException ioe) {
                        throw new AlfrescoRuntimeException("Unable to load rm-default-roles-bootstrap.json configuration file.", (Throwable)ioe);
                    }
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject object = array.getJSONObject(i);
                        String name = null;
                        if (object.has(FilePlanRoleServiceImpl.JSON_NAME)) {
                            name = object.getString(FilePlanRoleServiceImpl.JSON_NAME);
                            if (FilePlanRoleServiceImpl.this.existsRole(filePlan, name)) {
                                throw new AlfrescoRuntimeException("The bootstrap role " + name + " already exists on the rm root node " + filePlan.toString());
                            }
                        } else {
                            throw new AlfrescoRuntimeException("No name given to default bootstrap role.  Check json configuration file.");
                        }
                        String displayLabel = name;
                        if (object.has(FilePlanRoleServiceImpl.JSON_DISPLAY_LABEL)) {
                            displayLabel = object.getString(FilePlanRoleServiceImpl.JSON_DISPLAY_LABEL);
                        }
                        boolean isAdmin = false;
                        if (object.has(FilePlanRoleServiceImpl.JSON_IS_ADMIN)) {
                            isAdmin = object.getBoolean(FilePlanRoleServiceImpl.JSON_IS_ADMIN);
                        }
                        HashSet<Capability> capabilities = new HashSet<Capability>(30);
                        if (object.has(FilePlanRoleServiceImpl.JSON_CAPABILITIES)) {
                            JSONArray arrCaps = object.getJSONArray(FilePlanRoleServiceImpl.JSON_CAPABILITIES);
                            for (int index = 0; index < arrCaps.length(); ++index) {
                                String capName = arrCaps.getString(index);
                                Capability capability = FilePlanRoleServiceImpl.this.capabilityService.getCapability(capName);
                                if (capability == null) {
                                    throw new AlfrescoRuntimeException("The capability '" + capName + "' configured for the deafult boostrap role '" + name + "' is invalid.");
                                }
                                capabilities.add(capability);
                            }
                        }
                        Role role = FilePlanRoleServiceImpl.this.createRole(filePlan, name, displayLabel, capabilities);
                        if (!isAdmin) continue;
                        FilePlanRoleServiceImpl.this.permissionService.setPermission(filePlan, role.getRoleGroupName(), "Filing", true);
                        if (systemContainers != null) {
                            for (NodeRef systemContainer : systemContainers) {
                                FilePlanRoleServiceImpl.this.permissionService.setPermission(systemContainer, role.getRoleGroupName(), "Filing", true);
                            }
                        }
                        String user = AuthenticationUtil.getFullyAuthenticatedUser();
                        FilePlanRoleServiceImpl.this.authorityService.addAuthority(role.getRoleGroupName(), user);
                        if (AuthenticationUtil.getAdminUserName().equals(user)) continue;
                        FilePlanRoleServiceImpl.this.authorityService.addAuthority(role.getRoleGroupName(), AuthenticationUtil.getAdminUserName());
                    }
                }
                catch (JSONException exception) {
                    throw new AlfrescoRuntimeException("Error loading json configuration file rm-default-roles-bootstrap.json", (Throwable)exception);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean isSystemRole(String roleAuthority) {
        boolean isSystemRole = false;
        for (String systemRole : SYSTEM_ROLES) {
            if (!StringUtils.contains((CharSequence)roleAuthority, (CharSequence)systemRole)) continue;
            isSystemRole = true;
            break;
        }
        return isSystemRole;
    }

    @Override
    public Set<Role> getRoles(NodeRef rmRootNode) {
        return this.getRoles(rmRootNode, true);
    }

    @Override
    public Set<Role> getRoles(final NodeRef rmRootNode, final boolean includeSystemRoles) {
        return (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<Role>>(){

            public Set<Role> doWork() {
                HashSet<Role> result = new HashSet<Role>(13);
                Set roleAuthorities = FilePlanRoleServiceImpl.this.authorityService.getAllAuthoritiesInZone(FilePlanRoleServiceImpl.this.getZoneName(rmRootNode), AuthorityType.GROUP);
                for (String roleAuthority : roleAuthorities) {
                    if (!includeSystemRoles && FilePlanRoleServiceImpl.this.isSystemRole(roleAuthority)) continue;
                    String groupShortName = FilePlanRoleServiceImpl.this.authorityService.getShortName(roleAuthority);
                    String name = FilePlanRoleServiceImpl.this.getShortRoleName(groupShortName, rmRootNode);
                    String displayLabel = FilePlanRoleServiceImpl.this.authorityService.getAuthorityDisplayName(roleAuthority);
                    String translated = I18NUtil.getMessage((String)displayLabel);
                    if (translated != null) {
                        displayLabel = translated;
                    }
                    Set<Capability> capabilities = FilePlanRoleServiceImpl.this.getCapabilitiesImpl(rmRootNode, roleAuthority);
                    Role role = new Role(name, displayLabel, capabilities, roleAuthority, groupShortName);
                    result.add(role);
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public Set<Role> getRolesByUser(NodeRef rmRootNode, String user) {
        return this.getRolesByUser(rmRootNode, user, true);
    }

    @Override
    public Set<Role> getRolesByUser(final NodeRef rmRootNode, final String user, final boolean includeSystemRoles) {
        return (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<Role>>(){

            public Set<Role> doWork() {
                HashSet<Role> result = new HashSet<Role>(13);
                Set roleAuthorities = FilePlanRoleServiceImpl.this.authorityService.getAllAuthoritiesInZone(FilePlanRoleServiceImpl.this.getZoneName(rmRootNode), AuthorityType.GROUP);
                for (String roleAuthority : roleAuthorities) {
                    Set users = FilePlanRoleServiceImpl.this.authorityService.getContainedAuthorities(AuthorityType.USER, roleAuthority, false);
                    if (!users.contains(user) || !includeSystemRoles && FilePlanRoleServiceImpl.this.isSystemRole(roleAuthority)) continue;
                    String groupShortName = FilePlanRoleServiceImpl.this.authorityService.getShortName(roleAuthority);
                    String name = FilePlanRoleServiceImpl.this.getShortRoleName(groupShortName, rmRootNode);
                    String displayLabel = FilePlanRoleServiceImpl.this.authorityService.getAuthorityDisplayName(roleAuthority);
                    String translated = I18NUtil.getMessage((String)displayLabel);
                    if (translated != null) {
                        displayLabel = translated;
                    }
                    Set<Capability> capabilities = FilePlanRoleServiceImpl.this.getCapabilitiesImpl(rmRootNode, roleAuthority);
                    Role role = new Role(name, displayLabel, capabilities, roleAuthority, groupShortName);
                    result.add(role);
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private String getZoneName(NodeRef rmRootNode) {
        return RM_ROLE_ZONE_PREFIX + rmRootNode.getId();
    }

    private String getFullRoleName(String role, NodeRef rmRootNode) {
        return role + rmRootNode.getId();
    }

    private String getShortRoleName(String fullRoleName, NodeRef rmRootNode) {
        return fullRoleName.replaceAll(rmRootNode.getId(), "");
    }

    @Override
    public Role getRole(final NodeRef rmRootNode, final String role) {
        return (Role)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Role>(){

            public Role doWork() {
                Role result = null;
                String roleAuthority = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, rmRootNode));
                if (FilePlanRoleServiceImpl.this.authorityService.authorityExists(roleAuthority)) {
                    String name = FilePlanRoleServiceImpl.this.getShortRoleName(FilePlanRoleServiceImpl.this.authorityService.getShortName(roleAuthority), rmRootNode);
                    String displayLabel = FilePlanRoleServiceImpl.this.authorityService.getAuthorityDisplayName(roleAuthority);
                    Set<Capability> capabilities = FilePlanRoleServiceImpl.this.getCapabilitiesImpl(rmRootNode, roleAuthority);
                    result = new Role(name, displayLabel, capabilities, roleAuthority);
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private Set<Capability> getCapabilitiesImpl(NodeRef rmRootNode, String roleAuthority) {
        Set permissions = this.permissionService.getAllSetPermissions(rmRootNode);
        HashSet<Capability> capabilities = new HashSet<Capability>(52);
        for (AccessPermission permission : permissions) {
            String capabilityName;
            Capability capability;
            if (!permission.getAuthority().equals(roleAuthority) || (capability = this.capabilityService.getCapability(capabilityName = permission.getPermission())) == null || capability.isPrivate()) continue;
            capabilities.add(capability);
        }
        return capabilities;
    }

    @Override
    public boolean existsRole(final NodeRef rmRootNode, final String role) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() {
                String fullRoleName = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, rmRootNode));
                String zone = FilePlanRoleServiceImpl.this.getZoneName(rmRootNode);
                Set roles = FilePlanRoleServiceImpl.this.authorityService.getAllAuthoritiesInZone(zone, AuthorityType.GROUP);
                return roles.contains(fullRoleName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public boolean hasRMAdminRole(NodeRef rmRootNode, String user) {
        boolean isAdmin = false;
        Set<Role> userRoles = this.getRolesByUser(rmRootNode, user);
        if (userRoles != null) {
            for (Role role : userRoles) {
                if (!role.getName().equals("Administrator")) continue;
                isAdmin = true;
                break;
            }
        }
        return isAdmin;
    }

    @Override
    public Role createRole(final NodeRef filePlan, final String role, final String roleDisplayLabel, final Set<Capability> capabilities) {
        return (Role)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Role>(){

            public Role doWork() {
                String fullRoleName = FilePlanRoleServiceImpl.this.getFullRoleName(role, filePlan);
                if (FilePlanRoleServiceImpl.this.authorityService.authorityExists(FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, fullRoleName))) {
                    throw new AlfrescoRuntimeException("The role " + role + " already exists for root rm node " + filePlan.getId());
                }
                HashSet<String> zones = new HashSet<String>(2);
                zones.add(FilePlanRoleServiceImpl.this.getZoneName(filePlan));
                zones.add("APP.RM");
                String groupDisplayLabel = I18NUtil.getMessage((String)roleDisplayLabel);
                if (groupDisplayLabel == null) {
                    groupDisplayLabel = roleDisplayLabel;
                }
                String roleGroup = FilePlanRoleServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, fullRoleName, groupDisplayLabel, zones);
                if (!FilePlanRoleServiceImpl.this.isSystemRole(role)) {
                    String allRoleGroup = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getAllRolesGroupShortName(filePlan));
                    FilePlanRoleServiceImpl.this.authorityService.addAuthority(allRoleGroup, roleGroup);
                }
                if (capabilities != null) {
                    for (Capability capability : capabilities) {
                        FilePlanRoleServiceImpl.this.permissionService.setPermission(filePlan, roleGroup, capability.getName(), true);
                    }
                }
                return new Role(role, roleDisplayLabel, capabilities, roleGroup);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public Role updateRole(final NodeRef rmRootNode, final String role, final String roleDisplayLabel, final Set<Capability> capabilities) {
        return (Role)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Role>(){

            public Role doWork() {
                if (!FilePlanRoleServiceImpl.this.existsRole(rmRootNode, role)) {
                    throw new AlfrescoRuntimeException("Unable to update role " + role + ", because it does not exist.");
                }
                String roleAuthority = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, rmRootNode));
                FilePlanRoleServiceImpl.this.authorityService.setAuthorityDisplayName(roleAuthority, roleDisplayLabel);
                FilePlanRoleServiceImpl.this.permissionService.clearPermission(rmRootNode, roleAuthority);
                for (Capability capability : capabilities) {
                    FilePlanRoleServiceImpl.this.permissionService.setPermission(rmRootNode, roleAuthority, capability.getName(), true);
                }
                return new Role(role, roleDisplayLabel, capabilities, roleAuthority);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void deleteRole(final NodeRef rmRootNode, final String role) {
        if ("Administrator".equals(role)) {
            throw new AlfrescoRuntimeException("Can not delete the records management administration role.");
        }
        if (FilePlanRoleService.SYSTEM_ROLES.contains(role)) {
            throw new AlfrescoRuntimeException("'" + role + "' is a system role and cannot be deleted.");
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Void doWork() {
                String roleAuthority = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, rmRootNode));
                FilePlanRoleServiceImpl.this.authorityService.deleteAuthority(roleAuthority);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public Set<String> getUsersAssignedToRole(NodeRef filePlan, String roleName) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"roleName", (Object)roleName);
        return this.getAuthoritiesAssignedToRole(filePlan, roleName, AuthorityType.USER);
    }

    private Set<String> getAuthoritiesAssignedToRole(final NodeRef filePlan, final String roleName, final AuthorityType authorityType) {
        return (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<String>>(){

            public Set<String> doWork() {
                Role role = FilePlanRoleServiceImpl.this.getRole(filePlan, roleName);
                if (role == null) {
                    throw new AlfrescoRuntimeException("Can not get authorities for role " + roleName + ", because it does not exist. (filePlan=" + filePlan.toString() + ")");
                }
                return FilePlanRoleServiceImpl.this.authorityService.getContainedAuthorities(authorityType, role.getRoleGroupName(), true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public Set<String> getGroupsAssignedToRole(NodeRef filePlan, String roleName) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"roleName", (Object)roleName);
        return this.getAuthoritiesAssignedToRole(filePlan, roleName, AuthorityType.GROUP);
    }

    @Override
    public Set<String> getAllAssignedToRole(NodeRef filePlan, String role) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"roleName", (Object)role);
        HashSet<String> result = new HashSet<String>(21);
        result.addAll(this.getUsersAssignedToRole(filePlan, role));
        result.addAll(this.getGroupsAssignedToRole(filePlan, role));
        return result;
    }

    @Override
    public void assignRoleToAuthority(final NodeRef filePlan, final String role, final String authorityName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (FilePlanRoleServiceImpl.this.authorityService.authorityExists(authorityName) && !FilePlanRoleServiceImpl.this.getAllAssignedToRole(filePlan, role).contains(authorityName)) {
                    String roleAuthority = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, filePlan));
                    try {
                        FilePlanRoleServiceImpl.this.authorityService.addAuthority(roleAuthority, authorityName);
                    }
                    catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void unassignRoleFromAuthority(final NodeRef filePlan, final String role, final String authorityName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                String roleAuthority = FilePlanRoleServiceImpl.this.authorityService.getName(AuthorityType.GROUP, FilePlanRoleServiceImpl.this.getFullRoleName(role, filePlan));
                FilePlanRoleServiceImpl.this.authorityService.removeAuthority(roleAuthority, authorityName);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public String getAllRolesContainerGroup(NodeRef filePlan) {
        return this.authorityService.getName(AuthorityType.GROUP, this.getAllRolesGroupShortName(filePlan));
    }
}

