/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.model;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.servlet.FormData;

public class UploadInfo {
    private String fileName;
    private String nodeType;
    private String relativePath;
    private Content content;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public UploadInfo(FormData formData) {
        block12: for (FormData.FormField field : formData.getFields()) {
            switch (field.getName().toLowerCase()) {
                case "name": {
                    this.fileName = this.getStringOrNull(field.getValue());
                    continue block12;
                }
                case "nodetype": {
                    this.nodeType = this.getStringOrNull(field.getValue());
                    continue block12;
                }
                case "relativepath": {
                    this.relativePath = this.getStringOrNull(field.getValue());
                    continue block12;
                }
                case "filedata": {
                    if (!field.getIsFile()) continue block12;
                    this.fileName = this.fileName != null ? this.fileName : field.getFilename();
                    this.content = field.getContent();
                    continue block12;
                }
                default: {
                    String propName = field.getName();
                    if (propName.indexOf(58) <= -1) continue block12;
                    this.properties.put(propName, field.getValue());
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)this.fileName) || this.content == null) {
            throw new InvalidArgumentException("Required parameters are missing");
        }
    }

    private String getStringOrNull(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value.equalsIgnoreCase("null") ? null : value;
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Content getContent() {
        return this.content;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

