/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action;

import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AuditableActionExecuterAbstractBase
extends ActionExecuterAbstractBase
implements ApplicationContextAware {
    private boolean auditable = true;
    private boolean auditedImmediately = false;
    private ApplicationContext applicationContext;
    private RecordsManagementAuditService auditService;

    protected boolean isAuditable() {
        return this.auditable;
    }

    protected boolean isAuditedImmediately() {
        return this.auditedImmediately;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setAuditable(boolean auditable) {
        this.auditable = auditable;
    }

    public void setAuditedImmediately(boolean auditedImmediately) {
        this.auditedImmediately = auditedImmediately;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private RecordsManagementAuditService getAuditService() {
        if (this.auditService == null) {
            this.auditService = (RecordsManagementAuditService)this.getApplicationContext().getBean("recordsManagementAuditService");
        }
        return this.auditService;
    }

    public void init() {
        if (!(this instanceof RecordsManagementAction)) {
            super.init();
        }
        if (this.isAuditable()) {
            String name = this.getActionDefinition().getName();
            String title = this.getActionDefinition().getTitle();
            if (title == null || title.isEmpty()) {
                title = name;
            }
            this.getAuditService().registerAuditEvent(name, title);
        }
    }

    public void execute(Action action, NodeRef actionedUponNodeRef) {
        if (this.isAuditable()) {
            if (this.isAuditedImmediately()) {
                this.getAuditService().auditEvent(actionedUponNodeRef, this.getActionDefinition().getName(), null, null, true);
            } else {
                this.getAuditService().auditEvent(actionedUponNodeRef, this.getActionDefinition().getName());
            }
        }
        super.execute(action, actionedUponNodeRef);
    }
}

