/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v22;

import java.io.InputStream;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class RMv22ReportTemplatePatch
extends AbstractModulePatch {
    private static final String REPORT_TEMPLATE_PATH = "alfresco/module/org_alfresco_module_rm/bootstrap/report/report_rmr_transferReport.html.ftl";
    private static final String TRANSFER_REPORT = "rmr_transferReport";
    private static final String DESTRUCTION_REPORT = "rmr_destructionReport";
    private NodeService nodeService;
    private ContentService contentService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void applyInternal() {
        NodeRef transferReport = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, TRANSFER_REPORT);
        NodeRef destructionReport = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DESTRUCTION_REPORT);
        if (!this.nodeService.exists(transferReport) && this.nodeService.exists(destructionReport)) {
            NodeRef parent = this.nodeService.getPrimaryParent(destructionReport).getParentRef();
            QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"report_rmr_transferReport.html.ftl"));
            HashMap<QName, String> props = new HashMap<QName, String>(4);
            props.put(ContentModel.PROP_DESCRIPTION, "Transfer report template.");
            props.put(ContentModel.PROP_TITLE, "Transfer Report Template");
            props.put(ContentModel.PROP_NAME, "report_rmr_transferReport.html.ftl");
            props.put(ContentModel.PROP_NODE_UUID, TRANSFER_REPORT);
            ChildAssociationRef node = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_CONTENT, props);
            ContentWriter writer = this.contentService.getWriter(node.getChildRef(), ContentModel.PROP_CONTENT, true);
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(REPORT_TEMPLATE_PATH);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/plain");
            writer.putContent(is);
        }
    }
}

