/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public final class PoliciesUtil {
    private PoliciesUtil() {
    }

    public static Set<QName> getTypeAndAspectQNames(final NodeService nodeService, final NodeRef nodeRef) {
        return (Set)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<QName>>(){

            public Set<QName> doWork() {
                Set<QName> qnames = null;
                try {
                    Set aspectQNames = nodeService.getAspects(nodeRef);
                    QName typeQName = nodeService.getType(nodeRef);
                    qnames = new HashSet<QName>(aspectQNames.size() + 1);
                    qnames.addAll(aspectQNames);
                    qnames.add(typeQName);
                }
                catch (InvalidNodeRefException e) {
                    qnames = Collections.emptySet();
                }
                return qnames;
            }
        });
    }
}

