/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.search;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.search.ReportDetails;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetailsCompatibility;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ParameterCheck;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class SavedSearchDetails
extends ReportDetails {
    public static final String SITE_ID = "siteid";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String SEARCH = "search";
    public static final String PUBLIC = "public";
    public static final String REPORT = "report";
    public static final String SEARCHPARAMS = "searchparams";
    public static final String QUERY = "query";
    public static final String SORT = "sort";
    public static final String PARAMS = "params";
    private static final String DEFAULT_SITE_ID = "rm";
    private String siteId;
    private boolean isPublic = true;
    private boolean isReport = false;
    private NodeRef nodeRef = null;
    NamespaceService namespaceService;
    RecordsManagementSearchServiceImpl searchService;
    private SavedSearchDetailsCompatibility compatibility;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SavedSearchDetails createFromJSON(String jsonString, NamespaceService namespaceService, RecordsManagementSearchServiceImpl searchService, NodeRef nodeRef) {
        try {
            String translated;
            JSONObject search = new JSONObject(jsonString);
            String siteId = DEFAULT_SITE_ID;
            if (search.has(SITE_ID)) {
                siteId = search.getString(SITE_ID);
            }
            if (!search.has(NAME)) {
                throw new AlfrescoRuntimeException("Can not create saved search details from json, because required name is not present. " + jsonString);
            }
            String name = search.getString(NAME);
            String description = "";
            if (search.has(DESCRIPTION) && (translated = I18NUtil.getMessage((String)(description = search.getString(DESCRIPTION)))) != null) {
                description = translated;
            }
            String query = null;
            if (!search.has(SEARCH)) {
                if (!search.has(PARAMS)) throw new AlfrescoRuntimeException("Can not create saved search details from json, because required search is not present. " + jsonString);
                String oldParams = search.getString(PARAMS);
                query = SavedSearchDetailsCompatibility.getSearchFromParams(oldParams);
            } else {
                query = search.getString(SEARCH);
            }
            RecordsManagementSearchParameters searchParameters = new RecordsManagementSearchParameters();
            if (search.has(SEARCHPARAMS)) {
                searchParameters = RecordsManagementSearchParameters.createFromJSON(search.getJSONObject(SEARCHPARAMS), namespaceService);
            } else if (search.has(PARAMS)) {
                String oldParams = search.getString(PARAMS);
                String oldSort = search.getString(SORT);
                searchParameters = SavedSearchDetailsCompatibility.createSearchParameters(oldParams, oldSort, namespaceService);
            }
            boolean isPublic = true;
            if (search.has(PUBLIC)) {
                isPublic = search.getBoolean(PUBLIC);
            }
            boolean isReport = false;
            if (search.has(REPORT)) {
                isReport = search.getBoolean(REPORT);
            }
            SavedSearchDetails savedSearchDetails = new SavedSearchDetails(siteId, name, description, query, searchParameters, isPublic, isReport, namespaceService, searchService);
            savedSearchDetails.nodeRef = nodeRef;
            return savedSearchDetails;
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Can not create saved search details from json. " + jsonString, (Throwable)exception);
        }
    }

    SavedSearchDetails(String siteId, String name, String description, String serach, RecordsManagementSearchParameters searchParameters, boolean isPublic, boolean isReport, NamespaceService namespaceService, RecordsManagementSearchServiceImpl searchService) {
        super(name, description, serach, searchParameters);
        ParameterCheck.mandatory((String)"siteId", (Object)siteId);
        ParameterCheck.mandatory((String)"namespaceService", (Object)namespaceService);
        ParameterCheck.mandatory((String)"searchService", (Object)searchService);
        this.siteId = siteId;
        this.isPublic = isPublic;
        this.isReport = isReport;
        this.namespaceService = namespaceService;
        this.compatibility = new SavedSearchDetailsCompatibility(this, namespaceService, searchService);
        this.searchService = searchService;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public SavedSearchDetailsCompatibility getCompatibility() {
        return this.compatibility;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public String toJSONString() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(SITE_ID, (Object)this.siteId);
            jsonObject.put(NAME, (Object)this.name);
            jsonObject.put(DESCRIPTION, (Object)this.description);
            jsonObject.put(SEARCH, (Object)this.search);
            jsonObject.put(SEARCHPARAMS, (Object)this.searchParameters.toJSONObject(this.namespaceService));
            jsonObject.put(PUBLIC, this.isPublic);
            jsonObject.put(QUERY, (Object)this.searchService.buildQueryString(this.search, this.searchParameters));
            jsonObject.put(SORT, (Object)this.compatibility.getSort());
            return jsonObject.toString();
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Can not convert saved search details into JSON.", (Throwable)exception);
        }
    }
}

