/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.GUID;

public class UpdateHeldActiveContentTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testDeleteHeldDocument() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef hold = UpdateHeldActiveContentTest.this.holdService.createHold(UpdateHeldActiveContentTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                UpdateHeldActiveContentTest.this.holdService.addToHold(hold, UpdateHeldActiveContentTest.this.dmDocument);
            }

            @Override
            public void when() {
                try {
                    UpdateHeldActiveContentTest.this.fileFolderService.delete(UpdateHeldActiveContentTest.this.dmDocument);
                    TestCase.fail((String)"Expected PermissionDeniedException to be thrown");
                }
                catch (PermissionDeniedException pde) {
                    TestCase.assertTrue((boolean)pde.getMessage().contains(I18NUtil.getMessage((String)"rm.hold.delete-frozen-node")));
                }
            }
        });
    }

    public void testCopyHeldDocument() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){

            @Override
            public void given() {
                NodeRef hold = UpdateHeldActiveContentTest.this.holdService.createHold(UpdateHeldActiveContentTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                UpdateHeldActiveContentTest.this.holdService.addToHold(hold, UpdateHeldActiveContentTest.this.dmDocument);
            }

            @Override
            public void when() throws FileNotFoundException {
                UpdateHeldActiveContentTest.this.fileFolderService.copy(UpdateHeldActiveContentTest.this.dmDocument, UpdateHeldActiveContentTest.this.dmFolder1, null);
            }
        });
    }

    public void testMoveHeldDocument() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef hold = UpdateHeldActiveContentTest.this.holdService.createHold(UpdateHeldActiveContentTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                UpdateHeldActiveContentTest.this.holdService.addToHold(hold, UpdateHeldActiveContentTest.this.dmDocument);
            }

            @Override
            public void when() throws FileNotFoundException {
                try {
                    UpdateHeldActiveContentTest.this.fileFolderService.move(UpdateHeldActiveContentTest.this.dmDocument, UpdateHeldActiveContentTest.this.dmFolder1, null);
                    TestCase.fail((String)"Expected PermissionDeniedException to be thrown");
                }
                catch (PermissionDeniedException pde) {
                    TestCase.assertTrue((boolean)pde.getMessage().contains(I18NUtil.getMessage((String)"rm.hold.move-frozen-node")));
                }
            }
        });
    }

    public void testUpdateHeldDocumentProperties() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef hold = UpdateHeldActiveContentTest.this.holdService.createHold(UpdateHeldActiveContentTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                UpdateHeldActiveContentTest.this.holdService.addToHold(hold, UpdateHeldActiveContentTest.this.dmDocument);
            }

            @Override
            public void when() {
                try {
                    UpdateHeldActiveContentTest.this.nodeService.setProperty(UpdateHeldActiveContentTest.this.dmDocument, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description"));
                    TestCase.fail((String)"Expected PermissionDeniedException to be thrown");
                }
                catch (PermissionDeniedException pde) {
                    TestCase.assertTrue((boolean)pde.getMessage().contains(I18NUtil.getMessage((String)"rm.hold.update-frozen-node")));
                }
            }
        });
    }

    public void testUpdateHeldDocumentContent() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef hold = UpdateHeldActiveContentTest.this.holdService.createHold(UpdateHeldActiveContentTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                UpdateHeldActiveContentTest.this.holdService.addToHold(hold, UpdateHeldActiveContentTest.this.dmDocument);
            }

            @Override
            public void when() {
                try {
                    ContentData content = (ContentData)UpdateHeldActiveContentTest.this.nodeService.getProperty(UpdateHeldActiveContentTest.this.dmDocument, ContentModel.PROP_CONTENT);
                    UpdateHeldActiveContentTest.this.nodeService.setProperty(UpdateHeldActiveContentTest.this.dmDocument, ContentModel.PROP_CONTENT, (Serializable)ContentData.setMimetype((ContentData)content, (String)"text/plain"));
                    TestCase.fail((String)"Expected PermissionDeniedException to be thrown");
                }
                catch (PermissionDeniedException pde) {
                    TestCase.assertTrue((boolean)pde.getMessage().contains(I18NUtil.getMessage((String)"rm.hold.update-frozen-node")));
                }
            }
        });
    }
}

