/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.jscript.People;
import org.alfresco.repo.jscript.ScriptNode;
import org.json.JSONObject;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONUtils;
import org.springframework.extensions.webscripts.processor.FTLTemplateProcessor;

public abstract class BaseWebScriptUnitTest
extends BaseUnitTest {
    protected static final String WEBSCRIPT_ROOT_RM = "alfresco/templates/webscripts/org/alfresco/rma/";

    protected abstract AbstractWebScript getWebScript();

    protected abstract String getWebScriptTemplate();

    protected Map<String, String> buildParameters(String ... values) {
        HashMap<String, String> result = new HashMap<String, String>(values.length / 2);
        for (int i = 0; i < values.length; i += 2) {
            String key = values[i];
            String value = values[i + 1];
            result.put(key, value);
        }
        return result;
    }

    protected JSONObject executeJSONWebScript(Map<String, String> parameters) throws Exception {
        return this.executeJSONWebScript(parameters, null);
    }

    protected JSONObject executeJSONWebScript(Map<String, String> parameters, String content) throws Exception {
        String result = this.executeWebScript(parameters, content);
        return new JSONObject(result);
    }

    protected String executeWebScript(Map<String, String> parameters) throws Exception {
        return this.executeWebScript(parameters, null);
    }

    protected String executeWebScript(Map<String, String> parameters, String content) throws Exception {
        AbstractWebScript webScript = this.getWebScript();
        String template = this.getWebScriptTemplate();
        webScript.init(this.getMockedContainer(template), this.getMockedDescription());
        WebScriptResponse mockedResponse = this.getMockedWebScriptResponse();
        webScript.execute(this.getMockedWebScriptRequest(webScript, parameters, content), mockedResponse);
        return mockedResponse.getWriter().toString();
    }

    protected WebScriptRequest getMockedWebScriptRequest(AbstractWebScript webScript, final Map<String, String> parameters, String content) throws Exception {
        Match match = new Match(null, parameters, null, (WebScript)webScript);
        Runtime mockedRuntime = (Runtime)Mockito.mock(Runtime.class);
        WebScriptRequest mockedRequest = (WebScriptRequest)Mockito.mock(WebScriptRequest.class);
        ((WebScriptRequest)Mockito.lenient().doReturn((Object)match).when((Object)mockedRequest)).getServiceMatch();
        ((WebScriptRequest)Mockito.lenient().doReturn((Object)mockedRuntime).when((Object)mockedRequest)).getRuntime();
        if (content != null && !content.isEmpty()) {
            Content mockedContent = (Content)Mockito.mock(Content.class);
            ((Content)Mockito.lenient().doReturn((Object)content).when((Object)mockedContent)).getContent();
            ((WebScriptRequest)Mockito.lenient().doReturn((Object)mockedContent).when((Object)mockedRequest)).getContent();
        }
        String[] paramNames = parameters.keySet().toArray(new String[parameters.size()]);
        ((WebScriptRequest)Mockito.lenient().doReturn((Object)paramNames).when((Object)mockedRequest)).getParameterNames();
        ((WebScriptRequest)Mockito.lenient().doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String paramName = (String)invocation.getArguments()[0];
                return parameters.get(paramName);
            }
        }).when((Object)mockedRequest)).getParameter(ArgumentMatchers.anyString());
        ((WebScriptRequest)Mockito.lenient().doReturn((Object)new String[0]).when((Object)mockedRequest)).getHeaderNames();
        ((WebScriptRequest)Mockito.lenient().doReturn((Object)"json").when((Object)mockedRequest)).getFormat();
        return mockedRequest;
    }

    protected WebScriptResponse getMockedWebScriptResponse() throws Exception {
        WebScriptResponse mockedResponse = (WebScriptResponse)Mockito.mock(WebScriptResponse.class);
        StringWriter writer = new StringWriter();
        ((WebScriptResponse)Mockito.lenient().doReturn((Object)writer).when((Object)mockedResponse)).getWriter();
        return mockedResponse;
    }

    protected Container getMockedContainer(String template) throws Exception {
        FormatRegistry mockedFormatRegistry = (FormatRegistry)Mockito.mock(FormatRegistry.class);
        ((FormatRegistry)Mockito.lenient().doReturn((Object)"application/json").when((Object)mockedFormatRegistry)).getMimeType((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class));
        ScriptProcessorRegistry mockedScriptProcessorRegistry = (ScriptProcessorRegistry)Mockito.mock(ScriptProcessorRegistry.class);
        ((ScriptProcessorRegistry)Mockito.lenient().doReturn(null).when((Object)mockedScriptProcessorRegistry)).findValidScriptPath(ArgumentMatchers.anyString());
        TemplateProcessorRegistry mockedTemplateProcessorRegistry = (TemplateProcessorRegistry)Mockito.mock(TemplateProcessorRegistry.class);
        ((TemplateProcessorRegistry)Mockito.lenient().doReturn((Object)template).when((Object)mockedTemplateProcessorRegistry)).findValidTemplatePath(ArgumentMatchers.anyString());
        FTLTemplateProcessor ftlTemplateProcessor = new FTLTemplateProcessor(this){

            protected TemplateLoader getTemplateLoader() {
                return new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/");
            }
        };
        ftlTemplateProcessor.init();
        ((TemplateProcessorRegistry)Mockito.lenient().doReturn((Object)ftlTemplateProcessor).when((Object)mockedTemplateProcessorRegistry)).getTemplateProcessor(ArgumentMatchers.anyString());
        Container mockedContainer = (Container)Mockito.mock(Container.class);
        ((Container)Mockito.lenient().doReturn((Object)mockedFormatRegistry).when((Object)mockedContainer)).getFormatRegistry();
        ((Container)Mockito.lenient().doReturn((Object)mockedScriptProcessorRegistry).when((Object)mockedContainer)).getScriptProcessorRegistry();
        ((Container)Mockito.lenient().doReturn((Object)mockedTemplateProcessorRegistry).when((Object)mockedContainer)).getTemplateProcessorRegistry();
        HashMap<String, Object> containerTemplateParameters = new HashMap<String, Object>(5);
        containerTemplateParameters.put("jsonUtils", new JSONUtils());
        containerTemplateParameters.put("people", this.getMockedPeopleObject());
        ((Container)Mockito.lenient().doReturn(containerTemplateParameters).when((Object)mockedContainer)).getTemplateParameters();
        SearchPath mockedSearchPath = (SearchPath)Mockito.mock(SearchPath.class);
        ((SearchPath)Mockito.lenient().doReturn((Object)false).when((Object)mockedSearchPath)).hasDocument(ArgumentMatchers.anyString());
        ((Container)Mockito.lenient().doReturn((Object)mockedSearchPath).when((Object)mockedContainer)).getSearchPath();
        Description mockDescription = (Description)Mockito.mock(Description.class);
        ((Description)Mockito.lenient().doReturn(Mockito.mock(Description.RequiredCache.class)).when((Object)mockDescription)).getRequiredCache();
        return mockedContainer;
    }

    protected People getMockedPeopleObject() {
        People p = (People)Mockito.mock(People.class);
        this.getMockedPeople().forEach((name, person) -> Mockito.when((Object)p.getPerson((String)ArgumentMatchers.eq((Object)name))).thenReturn(person));
        return p;
    }

    protected Map<String, ScriptNode> getMockedPeople() {
        return Collections.emptyMap();
    }

    protected Description getMockedDescription() {
        Description mockedDescription = (Description)Mockito.mock(Description.class);
        ((Description)Mockito.doReturn((Object)Mockito.mock(Description.RequiredCache.class)).when((Object)mockedDescription)).getRequiredCache();
        return mockedDescription;
    }
}

