/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RecordsManagementSearchServiceImplTest
extends BaseRMTestCase {
    private static final String SEARCH1 = "search1";
    private static final String SEARCH2 = "search2";
    private static final String SEARCH3 = "search3";
    private static final String SEARCH4 = "search4";
    private String user;
    private int numberOfReports;

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List searches = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearches(RecordsManagementSearchServiceImplTest.this.siteId);
                TestCase.assertNotNull((Object)searches);
                RecordsManagementSearchServiceImplTest.this.numberOfReports = searches.size();
                RecordsManagementSearchServiceImplTest.this.user = GUID.generate();
                RecordsManagementSearchServiceImplTest.this.createPerson(RecordsManagementSearchServiceImplTest.this.user);
                return null;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    public void testSaveSearch() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                SavedSearchDetails details1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.saveSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "description1", "query1", new RecordsManagementSearchParameters(), true);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(details1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "description1", "query1", new RecordsManagementSearchParameters(), true);
                SavedSearchDetails details2 = RecordsManagementSearchServiceImplTest.this.rmSearchService.saveSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH2, "description2", "query2", new RecordsManagementSearchParameters(), false);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(details2, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH2, "description2", "query2", new RecordsManagementSearchParameters(), false);
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                SavedSearchDetails details1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.saveSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH3, "description3", "query3", new RecordsManagementSearchParameters(), false);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(details1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH3, "description3", "query3", new RecordsManagementSearchParameters(), false);
                SavedSearchDetails details2 = RecordsManagementSearchServiceImplTest.this.rmSearchService.saveSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH4, "description4", "query4", new RecordsManagementSearchParameters(), false);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(details2, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH4, "description4", "query4", new RecordsManagementSearchParameters(), false);
                return null;
            }
        }, this.user);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List searches = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearches(RecordsManagementSearchServiceImplTest.this.siteId);
                TestCase.assertNotNull((Object)searches);
                TestCase.assertEquals((int)(RecordsManagementSearchServiceImplTest.this.numberOfReports + 2), (int)searches.size());
                SavedSearchDetails search1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1);
                TestCase.assertNotNull((Object)search1);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "description1", "query1", new RecordsManagementSearchParameters(), true);
                SavedSearchDetails search2 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH2);
                TestCase.assertNotNull((Object)search2);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search2, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH2, "description2", "query2", new RecordsManagementSearchParameters(), false);
                SavedSearchDetails search3 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH3);
                TestCase.assertNull((Object)search3);
                SavedSearchDetails search4 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH4);
                TestCase.assertNull((Object)search4);
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List searches = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearches(RecordsManagementSearchServiceImplTest.this.siteId);
                TestCase.assertNotNull((Object)searches);
                TestCase.assertEquals((int)(RecordsManagementSearchServiceImplTest.this.numberOfReports + 3), (int)searches.size());
                SavedSearchDetails search1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1);
                TestCase.assertNotNull((Object)search1);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "description1", "query1", new RecordsManagementSearchParameters(), true);
                SavedSearchDetails search2 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH2);
                TestCase.assertNull((Object)search2);
                SavedSearchDetails search3 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH3);
                TestCase.assertNotNull((Object)search3);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search3, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH3, "description3", "query3", new RecordsManagementSearchParameters(), false);
                SavedSearchDetails search4 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH4);
                TestCase.assertNotNull((Object)search4);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search4, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH4, "description4", "query4", new RecordsManagementSearchParameters(), false);
                return null;
            }
        }, this.user);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                SavedSearchDetails search1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1);
                TestCase.assertNotNull((Object)search1);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "description1", "query1", new RecordsManagementSearchParameters(), true);
                RecordsManagementSearchServiceImplTest.this.rmSearchService.saveSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "change", "change", new RecordsManagementSearchParameters(), true);
                search1 = RecordsManagementSearchServiceImplTest.this.rmSearchService.getSavedSearch(RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1);
                TestCase.assertNotNull((Object)search1);
                RecordsManagementSearchServiceImplTest.this.checkSearchDetails(search1, RecordsManagementSearchServiceImplTest.this.siteId, RecordsManagementSearchServiceImplTest.SEARCH1, "change", "change", new RecordsManagementSearchParameters(), true);
                return null;
            }
        });
    }

    private void checkSearchDetails(SavedSearchDetails details, String siteid, String name, String description, String query, RecordsManagementSearchParameters searchParameters, boolean isPublic) {
        RecordsManagementSearchServiceImplTest.assertNotNull((Object)details);
        RecordsManagementSearchServiceImplTest.assertEquals((String)siteid, (String)details.getSiteId());
        RecordsManagementSearchServiceImplTest.assertEquals((String)name, (String)details.getName());
        RecordsManagementSearchServiceImplTest.assertEquals((String)description, (String)details.getDescription());
        RecordsManagementSearchServiceImplTest.assertEquals((String)query, (String)details.getSearch());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)isPublic, (boolean)details.isPublic());
        RecordsManagementSearchServiceImplTest.assertEquals((int)searchParameters.getMaxItems(), (int)details.getSearchParameters().getMaxItems());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeRecords(), (boolean)details.getSearchParameters().isIncludeRecords());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeUndeclaredRecords(), (boolean)details.getSearchParameters().isIncludeUndeclaredRecords());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeVitalRecords(), (boolean)details.getSearchParameters().isIncludeVitalRecords());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeRecordFolders(), (boolean)details.getSearchParameters().isIncludeRecordFolders());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeFrozen(), (boolean)details.getSearchParameters().isIncludeFrozen());
        RecordsManagementSearchServiceImplTest.assertEquals((boolean)searchParameters.isIncludeCutoff(), (boolean)details.getSearchParameters().isIncludeCutoff());
    }
}

