/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.caveat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.caveat.PivotUtil;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMConstraintInfo;
import org.alfresco.module.org_alfresco_module_rm.caveat.ScriptAuthority;
import org.alfresco.module.org_alfresco_module_rm.caveat.ScriptConstraintAuthority;
import org.alfresco.module.org_alfresco_module_rm.caveat.ScriptConstraintValue;
import org.alfresco.service.cmr.security.AuthorityService;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScriptConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RMConstraintInfo info;
    private RMCaveatConfigService rmCaveatconfigService;
    private AuthorityService authorityService;

    ScriptConstraint(RMConstraintInfo info, RMCaveatConfigService rmCaveatconfigService, AuthorityService authorityService) {
        this.info = info;
        this.rmCaveatconfigService = rmCaveatconfigService;
        this.authorityService = authorityService;
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public void setName(String name) {
        this.info.setName(name);
    }

    public String getName() {
        return this.info.getName().replace(":", "_");
    }

    public boolean isCaseSensitive() {
        return this.info.isCaseSensitive();
    }

    public String[] getAllowedValues() {
        return this.info.getAllowedValues();
    }

    public ScriptConstraintAuthority[] getAuthorities() {
        Map<String, List<String>> values = this.rmCaveatconfigService.getListDetails(this.info.getName());
        if (values == null) {
            return new ScriptConstraintAuthority[0];
        }
        ArrayList<ScriptConstraintAuthority> constraints = new ArrayList<ScriptConstraintAuthority>(values.size());
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            ScriptConstraintAuthority constraint = new ScriptConstraintAuthority();
            constraint.setAuthorityName(entry.getKey());
            constraint.setValues(entry.getValue());
            constraints.add(constraint);
        }
        return constraints.toArray(new ScriptConstraintAuthority[constraints.size()]);
    }

    public void updateTitle(String newTitle) {
        this.info.setTitle(newTitle);
        this.rmCaveatconfigService.updateRMConstraintTitle(this.info.getName(), newTitle);
    }

    public void updateAllowedValues(String[] allowedValues) {
        this.info.setAllowedValues(allowedValues);
        this.rmCaveatconfigService.updateRMConstraintAllowedValues(this.info.getName(), allowedValues);
    }

    public void updateValues(JSONArray bodge) throws Exception {
        for (int i = 0; i < bodge.length(); ++i) {
            JSONObject obj = bodge.getJSONObject(i);
            String value = obj.getString("value");
            JSONArray authorities = obj.getJSONArray("authorities");
            ArrayList<String> aList = new ArrayList<String>();
            for (int j = 0; j < authorities.length(); ++j) {
                aList.add(authorities.getString(j));
            }
            this.rmCaveatconfigService.updateRMConstraintListValue(this.info.getName(), value, aList);
        }
    }

    public void updateValues(String value, String[] authorities) {
        List<String> list = Arrays.asList(authorities);
        this.rmCaveatconfigService.updateRMConstraintListValue(this.info.getName(), value, list);
    }

    public void deleteAuthority(String authority) {
    }

    public void deleteValue(String value) {
    }

    public ScriptConstraintValue getValue(String value) {
        ScriptConstraintValue[] values;
        for (ScriptConstraintValue val : values = this.getValues()) {
            if (!val.getValueName().equalsIgnoreCase(value)) continue;
            return val;
        }
        return null;
    }

    public ScriptConstraintValue[] getValues() {
        Map<String, List<String>> details = this.rmCaveatconfigService.getListDetails(this.info.getName());
        if (details == null) {
            details = new HashMap<String, List<String>>();
        }
        Map<String, List<String>> pivot = PivotUtil.getPivot(details);
        ArrayList<ScriptConstraintValue> constraints = new ArrayList<ScriptConstraintValue>(pivot.size());
        for (Map.Entry<String, List<String>> entry : pivot.entrySet()) {
            ScriptConstraintValue constraint = new ScriptConstraintValue();
            constraint.setValueName(entry.getKey());
            constraint.setValueTitle(entry.getKey());
            List<String> authorities = entry.getValue();
            ArrayList<ScriptAuthority> sauth = new ArrayList<ScriptAuthority>();
            for (String authority : authorities) {
                ScriptAuthority a = new ScriptAuthority();
                a.setAuthorityName(authority);
                String displayName = this.authorityService.getAuthorityDisplayName(authority);
                if (StringUtils.isNotBlank((CharSequence)displayName)) {
                    a.setAuthorityTitle(displayName);
                } else {
                    a.setAuthorityTitle(authority);
                }
                sauth.add(a);
            }
            constraint.setAuthorities(sauth);
            constraints.add(constraint);
        }
        Set<String> values = pivot.keySet();
        for (String value : this.info.getAllowedValues()) {
            if (values.contains(value)) continue;
            ScriptConstraintValue constraint = new ScriptConstraintValue();
            constraint.setValueName(value);
            constraint.setValueTitle(value);
            ArrayList<ScriptAuthority> sauth = new ArrayList<ScriptAuthority>();
            constraint.setAuthorities(sauth);
            constraints.add(constraint);
        }
        return constraints.toArray(new ScriptConstraintValue[constraints.size()]);
    }
}

