/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.repo.web.scripts.content.StreamACP;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ExportPost
extends StreamACP {
    private static Log logger = LogFactory.getLog(ExportPost.class);
    protected static final String PARAM_TRANSFER_FORMAT = "transferFormat";
    private ContentStreamer contentStreamer;

    public void setContentStreamer(ContentStreamer contentStreamer) {
        this.contentStreamer = contentStreamer;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        File tempACPFile = null;
        try {
            NodeRef[] nodeRefs = null;
            boolean transferFormat = false;
            String contentType = req.getContentType();
            if ("multipart/form-data".equals(contentType)) {
                nodeRefs = this.getNodeRefs(req.getParameter("nodeRefs"));
                String transferFormatParam = req.getParameter(PARAM_TRANSFER_FORMAT);
                if (transferFormatParam != null && transferFormatParam.length() > 0) {
                    transferFormat = Boolean.parseBoolean(transferFormatParam);
                }
            } else {
                JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
                nodeRefs = this.getNodeRefs(json);
                if (json.has(PARAM_TRANSFER_FORMAT)) {
                    transferFormat = json.getBoolean(PARAM_TRANSFER_FORMAT);
                }
            }
            ExporterCrawlerParameters params = new ExporterCrawlerParameters();
            params.setCrawlSelf(true);
            params.setCrawlChildNodes(true);
            params.setExportFrom(new Location(nodeRefs));
            if (transferFormat) {
                QName[] excludedAspects = new QName[]{RenditionModel.ASPECT_RENDITIONED, ContentModel.ASPECT_THUMBNAILED, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE, RecordsManagementSearchBehaviour.ASPECT_RM_SEARCH, RecordsManagementModel.ASPECT_EXTENDED_SECURITY};
                params.setExcludeAspects(excludedAspects);
            } else {
                QName[] excludedAspects = new QName[]{RecordsManagementModel.ASPECT_EXTENDED_SECURITY};
                params.setExcludeAspects(excludedAspects);
            }
            tempACPFile = this.createACP(params, transferFormat ? "zip" : "acp", transferFormat);
            this.contentStreamer.streamContent(req, res, tempACPFile, null, true, tempACPFile.getName(), null);
        }
        catch (IOException ioe) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)ioe);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                logger.debug((Object)("Caught exception; decorating with appropriate status template : " + stack.toString()));
            }
            throw this.createStatusException(e, req, res);
        }
        finally {
            if (tempACPFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting temporary archive: " + tempACPFile.getAbsolutePath()));
                }
                tempACPFile.delete();
            }
        }
    }
}

