/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.WebScriptUtils;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomRefPost
extends AbstractRmWebScript {
    private static final String TO_NODE = "toNode";
    private static final String REF_ID = "refId";
    private RelationshipService relationshipService;
    private RuleService ruleService;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected RuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        try {
            this.getRuleService().disableRuleType("inbound");
            this.addCustomRelationship(req);
            model.put("success", true);
        }
        finally {
            this.getRuleService().enableRuleType("inbound");
        }
        return model;
    }

    protected void addCustomRelationship(WebScriptRequest req) {
        JSONObject json = WebScriptUtils.getRequestContentAsJSONObject(req);
        String uniqueName = WebScriptUtils.getStringValueFromJSONObject(json, REF_ID);
        NodeRef target = this.getTargetNode(json);
        NodeRef source = this.parseRequestForNodeRef(req);
        if (uniqueName.endsWith("__invert")) {
            String uniqueNameStem = uniqueName.split("__invert")[0];
            this.getRelationshipService().addRelationship(uniqueNameStem, target, source);
        } else {
            this.getRelationshipService().addRelationship(uniqueName, source, target);
        }
    }

    private NodeRef getTargetNode(JSONObject json) {
        String targetNodeString = WebScriptUtils.getStringValueFromJSONObject(json, TO_NODE);
        NodeRef targetNode = new NodeRef(targetNodeString);
        if (!this.getNodeService().exists(targetNode)) {
            throw new WebScriptException(404, "Unable to find the target node: '" + targetNode.toString() + "'.");
        }
        return targetNode;
    }
}

