/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.script.admin.RoleDeclarativeWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RmRolePut
extends RoleDeclarativeWebScript {
    private CapabilityService capabilityService;

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        JSONObject json = null;
        try {
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String roleParam = (String)templateVars.get("rolename");
            if (roleParam == null) {
                throw new WebScriptException(404, "No role name was provided on the URL.");
            }
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            String name = json.getString("name");
            String displayLabel = json.getString("displayLabel");
            JSONArray capabilitiesArray = json.getJSONArray("capabilities");
            HashSet<Capability> capabilites = new HashSet<Capability>(capabilitiesArray.length());
            for (int i = 0; i < capabilitiesArray.length(); ++i) {
                Capability capability = this.capabilityService.getCapability(capabilitiesArray.getString(i));
                capabilites.add(capability);
            }
            NodeRef filePlan = this.getFilePlan(req);
            if (filePlan == null) {
                throw new WebScriptException(404, "File plan does not exist.");
            }
            if (!this.filePlanRoleService.existsRole(filePlan, roleParam)) {
                throw new WebScriptException(404, "The role " + roleParam + " does not exist on the records managment root " + String.valueOf(filePlan));
            }
            Role role = this.filePlanRoleService.updateRole(filePlan, name, displayLabel, capabilites);
            model.put("role", new RoleDeclarativeWebScript.RoleItem(this, role));
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return model;
    }
}

