/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServicePolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class RemoveFromHoldTest
extends BaseRMTestCase
implements HoldServicePolicies.BeforeRemoveFromHoldPolicy,
HoldServicePolicies.OnRemoveFromHoldPolicy {
    private static final int RECORD_COUNT = 10;
    private boolean beforeRemoveFromHoldFlag = false;
    private boolean onRemoveFromHoldFlag = false;

    public void testRemoveRecordsFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                this.hold = RemoveFromHoldTest.this.holdService.createHold(RemoveFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = RemoveFromHoldTest.this.filePlanService.createRecordCategory(RemoveFromHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = RemoveFromHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(RemoveFromHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                RemoveFromHoldTest.this.holdService.addToHold(this.hold, this.records);
            }

            @Override
            public void when() throws Exception {
                RemoveFromHoldTest.this.holdService.removeFromHold(this.hold, this.records.subList(0, 5));
            }

            @Override
            public void then() {
                for (NodeRef record : this.records.subList(0, 5)) {
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                for (NodeRef record : this.records.subList(5, 10)) {
                    TestCase.assertTrue((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(record));
                    TestCase.assertTrue((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertTrue((boolean)RemoveFromHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)5, (Object)RemoveFromHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testRemoveAllRecordsFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                this.hold = RemoveFromHoldTest.this.holdService.createHold(RemoveFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = RemoveFromHoldTest.this.filePlanService.createRecordCategory(RemoveFromHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = RemoveFromHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(RemoveFromHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                RemoveFromHoldTest.this.holdService.addToHold(this.hold, this.records);
            }

            @Override
            public void when() throws Exception {
                RemoveFromHoldTest.this.holdService.removeFromHold(this.hold, this.records);
            }

            @Override
            public void then() {
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)RemoveFromHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testRemoveRecordFolderFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                this.hold = RemoveFromHoldTest.this.holdService.createHold(RemoveFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = RemoveFromHoldTest.this.filePlanService.createRecordCategory(RemoveFromHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = RemoveFromHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(RemoveFromHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                RemoveFromHoldTest.this.holdService.addToHold(this.hold, this.recordFolder);
            }

            @Override
            public void when() throws Exception {
                RemoveFromHoldTest.this.holdService.removeFromHold(this.hold, this.recordFolder);
            }

            @Override
            public void then() {
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)RemoveFromHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testPolicyNotificationForRemoveFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            BehaviourDefinition<ClassBehaviourBinding> beforeRemoveFromHoldBehaviour;
            BehaviourDefinition<ClassBehaviourBinding> onRemoveFromHoldBehaviour;

            @Override
            public void given() {
                this.hold = RemoveFromHoldTest.this.holdService.createHold(RemoveFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = RemoveFromHoldTest.this.filePlanService.createRecordCategory(RemoveFromHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = RemoveFromHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                RemoveFromHoldTest.this.holdService.addToHold(this.hold, this.recordFolder);
                this.beforeRemoveFromHoldBehaviour = RemoveFromHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.BeforeRemoveFromHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)RemoveFromHoldTest.this, "beforeRemoveFromHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                this.onRemoveFromHoldBehaviour = RemoveFromHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.OnRemoveFromHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)RemoveFromHoldTest.this, "onRemoveFromHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.beforeRemoveFromHoldFlag);
                TestCase.assertFalse((boolean)RemoveFromHoldTest.this.onRemoveFromHoldFlag);
            }

            @Override
            public void when() throws Exception {
                RemoveFromHoldTest.this.holdService.removeFromHold(this.hold, this.recordFolder);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.beforeRemoveFromHoldFlag);
                TestCase.assertTrue((boolean)RemoveFromHoldTest.this.onRemoveFromHoldFlag);
            }

            @Override
            public void after() {
                RemoveFromHoldTest.this.policyComponent.removeClassDefinition(this.beforeRemoveFromHoldBehaviour);
                RemoveFromHoldTest.this.policyComponent.removeClassDefinition(this.onRemoveFromHoldBehaviour);
            }
        });
    }

    public void beforeRemoveFromHold(NodeRef hold, NodeRef contentNodeRef) {
        this.beforeRemoveFromHoldFlag = true;
    }

    public void onRemoveFromHold(NodeRef hold, NodeRef contentNodeRef) {
        this.onRemoveFromHoldFlag = true;
    }
}

