/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1030Test
extends BaseRMTestCase {
    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testRM1030() throws Exception {
        final NodeRef recordHold = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                Set auths = RM1030Test.this.filePlanRoleService.getAllAssignedToRole(RM1030Test.this.filePlan, "Administrator");
                for (String auth : auths) {
                    System.out.println(auth);
                }
                List holds = RM1030Test.this.holdService.getHolds(RM1030Test.this.filePlan);
                TestCase.assertNotNull((Object)holds);
                TestCase.assertEquals((int)0, (int)holds.size());
                NodeRef hold = RM1030Test.this.holdService.createHold(RM1030Test.this.filePlan, "my hold 2", "in true life for serious", "my decription");
                RM1030Test.this.holdService.addToHold(hold, RM1030Test.this.recordOne);
                TestCase.assertNotNull((Object)hold);
                return hold;
            }

            public void test(NodeRef hold) throws Exception {
                TestCase.assertTrue((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.recordOne));
                List holds = RM1030Test.this.holdService.getHolds(RM1030Test.this.filePlan);
                TestCase.assertNotNull((Object)holds);
                TestCase.assertEquals((int)1, (int)holds.size());
            }
        });
        final NodeRef recordFolderHold = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef folderHold = RM1030Test.this.holdService.createHold(RM1030Test.this.filePlan, "my hold 3", "innit but", "my decription");
                RM1030Test.this.holdService.addToHold(folderHold, RM1030Test.this.rmFolder);
                TestCase.assertNotNull((Object)folderHold);
                return folderHold;
            }

            public void test(NodeRef hold) throws Exception {
                TestCase.assertTrue((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.recordOne));
                TestCase.assertTrue((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.rmFolder));
                List holds = RM1030Test.this.holdService.getHolds(RM1030Test.this.filePlan);
                TestCase.assertNotNull((Object)holds);
                TestCase.assertEquals((int)2, (int)holds.size());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1030Test.this.holdService.deleteHold(recordFolderHold);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertTrue((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.recordOne));
                TestCase.assertFalse((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.rmFolder));
                List holds = RM1030Test.this.holdService.getHolds(RM1030Test.this.filePlan);
                TestCase.assertNotNull((Object)holds);
                TestCase.assertEquals((int)1, (int)holds.size());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM1030Test.this.holdService.deleteHold(recordHold);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.recordOne));
                TestCase.assertFalse((boolean)RM1030Test.this.freezeService.isFrozen(RM1030Test.this.rmFolder));
                List holds = RM1030Test.this.holdService.getHolds(RM1030Test.this.filePlan);
                TestCase.assertNotNull((Object)holds);
                TestCase.assertEquals((int)0, (int)holds.size());
            }
        });
    }
}

