/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.record;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.RecordsManagementContainerType;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelAccessDeniedException;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.module.org_alfresco_module_rm.record.RecordCreationException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordLinkRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordMissingMetadataException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordUtils;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.PoliciesUtil;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IncompleteNodeTagger;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.impl.ExtendedPermissionService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean
public class RecordServiceImpl
extends BaseBehaviourBean
implements RecordService,
RecordsManagementModel,
RecordsManagementCustomModel,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
ContentServicePolicies.OnContentUpdatePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordServiceImpl.class);
    private static final String SYNC_MODEL_1_0_URI = "http://www.alfresco.org/model/sync/1.0";
    private static final QName ASPECT_SYNCED = QName.createQName((String)"http://www.alfresco.org/model/sync/1.0", (String)"synced");
    private static final String KEY_IGNORE_ON_UPDATE = "ignoreOnUpdate";
    public static final String KEY_NEW_RECORDS = "newRecords";
    private static final String MSG_NODE_HAS_ASPECT = "rm.service.node-has-aspect";
    private static final String FINAL_VERSION = "rm.service.final-version";
    private static final String FINAL_DESCRIPTION = "rm.service.final-version-description";
    private static final String MSG_UNDECLARED_ONLY_RECORDS = "rm.action.undeclared-only-records";
    private static final String MSG_NO_DECLARE_MAND_PROP = "rm.action.no-declare-mand-prop";
    private static final String MSG_CANNOT_CREATE_CHILDREN_IN_CLOSED_RECORD_FOLDER = "rm.service.add-children-to-closed-record-folder";
    private static final QName[] ALWAYS_EDIT_PROPERTIES = new QName[]{ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA};
    private List<String> alwaysEditURIs;
    private boolean checkMandatoryPropertiesEnabled = true;
    private List<String> recordModelURIs;
    private static final String[] NON_RECORD_MODEL_URIS = new String[]{"http://www.alfresco.org/model/audio/1.0", "http://www.alfresco.org/model/content/1.0", "http://www.alfresco.org/model/emailserver/1.0", "http://www.alfresco.org/model/exif/1.0", "http://www.alfresco.org/model/forum/1.0", "http://www.alfresco.org/model/linksmodel/1.0", "http://www.alfresco.org/view/repository/1.0"};
    private IdentifierService identifierService;
    private ExtendedPermissionService extendedPermissionService;
    private ExtendedSecurityService extendedSecurityService;
    private FilePlanService filePlanService;
    private RecordsManagementNotificationHelper notificationHelper;
    private PolicyComponent policyComponent;
    private OwnableService ownableService;
    private CapabilityService capabilityService;
    private RuleService ruleService;
    private FileFolderService fileFolderService;
    private RecordFolderService recordFolderService;
    private FilePlanRoleService filePlanRoleService;
    private PermissionService permissionService;
    private VersionService versionService;
    private RelationshipService relationshipService;
    private DispositionService dispositionService;
    private RecordsManagementContainerType recordsManagementContainerType;
    private RecordableVersionService recordableVersionService;
    private Map<QName, Set<QName>> recordMetaDataAspects;
    private FreezeService freezeService;
    private NamespaceService namespaceService;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeFileRecord> beforeFileRecord;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnFileRecord> onFileRecord;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeRecordDeclaration> beforeRecordDeclarationDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnRecordDeclaration> onRecordDeclarationDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeRecordRejection> beforeRecordRejectionDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnRecordRejection> onRecordRejectionDelegate;
    private IncompleteNodeTagger incompleteNodeTagger;

    public void setAlwaysEditURIs(List<String> alwaysEditURIs) {
        this.alwaysEditURIs = alwaysEditURIs;
    }

    protected List<String> getAlwaysEditURIs() {
        return this.alwaysEditURIs;
    }

    public void setRecordModelURIs(List<String> recordModelURIs) {
        this.recordModelURIs = recordModelURIs;
    }

    public RecordableVersionService getRecordableVersionService() {
        return this.recordableVersionService;
    }

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    public void setExtendedPermissionService(ExtendedPermissionService extendedPermissionService) {
        this.extendedPermissionService = extendedPermissionService;
    }

    public void setExtendedSecurityService(ExtendedSecurityService extendedSecurityService) {
        this.extendedSecurityService = extendedSecurityService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNotificationHelper(RecordsManagementNotificationHelper notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordsManagementContainerType(RecordsManagementContainerType recordsManagementContainerType) {
        this.recordsManagementContainerType = recordsManagementContainerType;
    }

    public void setRecordableVersionService(RecordableVersionService recordableVersionService) {
        this.recordableVersionService = recordableVersionService;
    }

    public void setIncompleteNodeTagger(IncompleteNodeTagger incompleteNodeTagger) {
        this.incompleteNodeTagger = incompleteNodeTagger;
    }

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCheckMandatoryPropertiesEnabled(boolean checkMandatoryPropertiesEnabled) {
        this.checkMandatoryPropertiesEnabled = checkMandatoryPropertiesEnabled;
    }

    public void init() {
        this.beforeFileRecord = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.BeforeFileRecord.class);
        this.onFileRecord = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.OnFileRecord.class);
        this.beforeRecordDeclarationDelegate = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.BeforeRecordDeclaration.class);
        this.onRecordDeclarationDelegate = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.OnRecordDeclaration.class);
        this.beforeRecordRejectionDelegate = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.BeforeRecordRejection.class);
        this.onRecordRejectionDelegate = this.policyComponent.registerClassPolicy(RecordsManagementPolicies.OnRecordRejection.class);
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onAddAspect(final NodeRef nodeRef, QName aspect) {
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (RecordServiceImpl.this.nodeService.exists(nodeRef) && RecordServiceImpl.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD)) {
                    RecordUtils.generateRecordIdentifier(RecordServiceImpl.this.nodeService, RecordServiceImpl.this.identifierService, nodeRef);
                    RecordServiceImpl.this.reevaluateIncompleteTag(nodeRef);
                }
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="sys:noContent")
    public void onRemoveAspect(NodeRef nodeRef, QName aspect) {
        ContentData contentData;
        if (this.nodeService.hasAspect(nodeRef, ASPECT_RECORD) && ContentData.hasContent((ContentData)(contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT))) && contentData.getSize() > 0L) {
            RecordUtils.appendIdentifierToName(this.nodeService, nodeRef);
            this.reevaluateIncompleteTag(nodeRef);
        }
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, type="rma:recordFolder", notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, final boolean bNew) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                try {
                    NodeRef nodeRef = childAssocRef.getChildRef();
                    if (RecordServiceImpl.this.nodeService.exists(nodeRef) && !RecordServiceImpl.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY) && !RecordServiceImpl.this.nodeService.getType(nodeRef).equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER) && !RecordServiceImpl.this.nodeService.getType(nodeRef).equals((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY)) {
                        if (bNew) {
                            Set newRecords = RecordServiceImpl.this.transactionalResourceHelper.getSet(RecordServiceImpl.KEY_NEW_RECORDS);
                            newRecords.add(nodeRef);
                        } else {
                            NodeRef parentNodeRef = childAssocRef.getParentRef();
                            if (RecordServiceImpl.this.isRecord(nodeRef) && RecordServiceImpl.this.isRecordFolder(parentNodeRef)) {
                                RecordServiceImpl.this.validateLinkConditions(nodeRef, parentNodeRef);
                            }
                        }
                        RecordServiceImpl.this.file(nodeRef);
                        RecordServiceImpl.this.dispositionService.recalculateNextDispositionStep(nodeRef);
                    }
                }
                catch (RecordLinkRuntimeException e) {
                    throw e;
                }
                catch (AlfrescoRuntimeException e) {
                    LOGGER.warn("Unable to file pending record.", (Throwable)e);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void disablePropertyEditableCheck() {
        org.alfresco.repo.policy.Behaviour behaviour = this.getBehaviour("onUpdateProperties");
        if (behaviour != null) {
            this.getBehaviour("onUpdateProperties").disable();
        }
    }

    @Override
    public void disablePropertyEditableCheck(NodeRef nodeRef) {
        Set ignoreOnUpdate = this.transactionalResourceHelper.getSet(KEY_IGNORE_ON_UPDATE);
        ignoreOnUpdate.add(nodeRef);
    }

    @Override
    public void enablePropertyEditableCheck() {
        org.alfresco.repo.policy.Behaviour behaviour = this.getBehaviour("onUpdateProperties");
        if (behaviour != null) {
            behaviour.enable();
        }
    }

    @Behaviour(name="onUpdateProperties", kind=BehaviourKind.CLASS, type="rma:record")
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (AuthenticationUtil.getFullyAuthenticatedUser() != null && !AuthenticationUtil.isRunAsUserTheSystemUser() && this.nodeService.exists(nodeRef) && this.isRecord(nodeRef) && !this.transactionalResourceHelper.getSet(KEY_IGNORE_ON_UPDATE).contains(nodeRef)) {
            for (Map.Entry<QName, Serializable> entry : after.entrySet()) {
                Serializable beforeValue = null;
                QName property = entry.getKey();
                if (before != null) {
                    beforeValue = before.get(property);
                }
                Serializable afterValue = entry.getValue();
                boolean propertyUnchanged = false;
                if (beforeValue instanceof Date && afterValue instanceof Date) {
                    Calendar beforeCal = Calendar.getInstance();
                    beforeCal.setTime((Date)beforeValue);
                    Calendar afterCal = Calendar.getInstance();
                    afterCal.setTime((Date)afterValue);
                    beforeCal.set(13, 0);
                    beforeCal.set(14, 0);
                    afterCal.set(13, 0);
                    afterCal.set(14, 0);
                    propertyUnchanged = beforeCal.compareTo(afterCal) == 0;
                } else {
                    propertyUnchanged = afterValue instanceof Boolean && beforeValue == null && afterValue.equals(Boolean.FALSE) ? true : EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue);
                }
                if (propertyUnchanged || ContentModel.PROP_CONTENT.equals((Object)property) && beforeValue == null || this.isPropertyEditable(nodeRef, property)) continue;
                throw new ModelAccessDeniedException("The user " + AuthenticationUtil.getFullyAuthenticatedUser() + " does not have the permission to edit the record property " + property.toString() + " on the node " + nodeRef.toString());
            }
        }
    }

    protected Map<QName, Set<QName>> getRecordMetadataAspectsMap() {
        if (this.recordMetaDataAspects == null) {
            this.recordMetaDataAspects = new HashMap<QName, Set<QName>>();
            this.initRecordMetaDataMap();
        }
        return this.recordMetaDataAspects;
    }

    private void initRecordMetaDataMap() {
        Collection aspects = this.dictionaryService.getAllAspects();
        for (QName aspect : aspects) {
            QName parent;
            AspectDefinition def = this.dictionaryService.getAspect(aspect);
            if (def == null || (parent = def.getParentName()) == null || !ASPECT_RECORD_META_DATA.equals((Object)parent)) continue;
            this.recordMetaDataAspects.put(aspect, Collections.singleton(TYPE_FILE_PLAN));
        }
    }

    @Override
    public void registerRecordMetadataAspect(QName recordMetadataAspect, QName filePlanType) {
        ParameterCheck.mandatory((String)"recordMetadataAspect", (Object)recordMetadataAspect);
        ParameterCheck.mandatory((String)"filePlanType", (Object)filePlanType);
        Set<Object> filePlanTypes = null;
        if (this.getRecordMetadataAspectsMap().containsKey(recordMetadataAspect)) {
            filePlanTypes = this.getRecordMetadataAspectsMap().get(recordMetadataAspect);
        } else {
            filePlanTypes = new HashSet(1);
            this.getRecordMetadataAspectsMap().put(recordMetadataAspect, filePlanTypes);
        }
        filePlanTypes.add(filePlanType);
    }

    @Override
    @Deprecated
    public Set<QName> getRecordMetaDataAspects() {
        return this.getRecordMetadataAspects(TYPE_FILE_PLAN);
    }

    @Override
    public boolean isRecordMetadataAspect(QName aspect) {
        return this.getRecordMetadataAspectsMap().containsKey(aspect);
    }

    @Override
    public boolean isRecordMetadataProperty(QName property) {
        ClassDefinition classDefinition;
        boolean result = false;
        PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(property);
        if (propertyDefinition != null && (classDefinition = propertyDefinition.getContainerClass()) != null && this.getRecordMetadataAspectsMap().containsKey(classDefinition.getName())) {
            result = true;
        }
        return result;
    }

    @Override
    public Set<QName> getRecordMetadataAspects(NodeRef nodeRef) {
        QName filePlanType = TYPE_FILE_PLAN;
        if (nodeRef != null) {
            NodeRef filePlan = this.getFilePlan(nodeRef);
            filePlanType = this.nodeService.getType(filePlan);
        }
        return this.getRecordMetadataAspects(filePlanType);
    }

    @Override
    public Set<QName> getRecordMetadataAspects(QName filePlanType) {
        HashSet<QName> result = new HashSet<QName>(this.getRecordMetadataAspectsMap().size());
        for (Map.Entry<QName, Set<QName>> entry : this.getRecordMetadataAspectsMap().entrySet()) {
            if (!entry.getValue().contains(filePlanType)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public void createRecord(NodeRef filePlan, NodeRef nodeRef) {
        this.createRecord(filePlan, nodeRef, true);
    }

    @Override
    public void createRecord(NodeRef filePlan, NodeRef nodeRef, boolean isLinked) {
        this.createRecord(filePlan, nodeRef, null, isLinked);
    }

    @Override
    public void createRecord(NodeRef filePlan, NodeRef nodeRef, NodeRef destinationNodeRef) {
        this.createRecord(filePlan, nodeRef, destinationNodeRef, true);
    }

    @Override
    public void createRecord(NodeRef filePlan, final NodeRef nodeRef, NodeRef destinationNodeRef, final boolean isLinked) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"isLinked", (Object)isLinked);
        this.recordCreationSanityCheckOnNode(nodeRef);
        final NodeRef newRecordContainer = this.recordCreationSanityCheckOnDestinationNode(destinationNodeRef, filePlan);
        this.invokeBeforeRecordDeclaration(nodeRef);
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() {
                block12: {
                    if (!RecordServiceImpl.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD)) {
                        RecordServiceImpl.this.ruleService.disableRuleType("outbound");
                        try {
                            Pair<Set<String>, Set<String>> readersAndWriters = RecordServiceImpl.this.extendedPermissionService.getReadersAndWriters(nodeRef);
                            String owner = RecordServiceImpl.this.ownableService.getOwner(nodeRef);
                            ChildAssociationRef parentAssoc = RecordServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
                            NodeRef latestVersionRecord = RecordServiceImpl.this.getLatestVersionRecord(nodeRef);
                            RecordServiceImpl.this.behaviourFilter.disableBehaviour();
                            try {
                                RecordServiceImpl.this.nodeService.moveNode(nodeRef, newRecordContainer, ContentModel.ASSOC_CONTAINS, parentAssoc.getQName());
                            }
                            finally {
                                RecordServiceImpl.this.behaviourFilter.enableBehaviour();
                            }
                            HashMap<QName, Object> aspectProperties = new HashMap<QName, Object>(3);
                            aspectProperties.put(RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION, parentAssoc.getParentRef());
                            aspectProperties.put(RecordsManagementModel.PROP_RECORD_ORIGINATING_USER_ID, owner);
                            aspectProperties.put(RecordsManagementModel.PROP_RECORD_ORIGINATING_CREATION_DATE, new Date());
                            RecordServiceImpl.this.nodeService.addAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD_ORIGINATING_DETAILS, aspectProperties);
                            RecordServiceImpl.this.makeRecord(nodeRef);
                            RecordUtils.generateRecordIdentifier(RecordServiceImpl.this.nodeService, RecordServiceImpl.this.identifierService, nodeRef);
                            if (latestVersionRecord != null) {
                                PropertyMap versionRecordProps = new PropertyMap(2);
                                versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_LABEL, (Object)I18NUtil.getMessage((String)RecordServiceImpl.FINAL_VERSION));
                                versionRecordProps.put((Object)RecordableVersionModel.PROP_VERSION_DESCRIPTION, (Object)I18NUtil.getMessage((String)RecordServiceImpl.FINAL_DESCRIPTION));
                                RecordServiceImpl.this.nodeService.addAspect(nodeRef, RecordableVersionModel.ASPECT_VERSION_RECORD, (Map)versionRecordProps);
                                RecordServiceImpl.this.relationshipService.addRelationship(RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName(), nodeRef, latestVersionRecord);
                            }
                            if (!isLinked) break block12;
                            RecordServiceImpl.this.ruleService.disableRules();
                            try {
                                RecordServiceImpl.this.nodeService.addChild(parentAssoc.getParentRef(), nodeRef, parentAssoc.getTypeQName(), parentAssoc.getQName());
                                RecordServiceImpl.this.extendedSecurityService.set(nodeRef, readersAndWriters);
                            }
                            finally {
                                RecordServiceImpl.this.ruleService.enableRules();
                            }
                        }
                        finally {
                            RecordServiceImpl.this.ruleService.enableRuleType("outbound");
                        }
                    }
                }
                return null;
            }
        });
        this.invokeOnRecordDeclaration(nodeRef);
    }

    private NodeRef recordCreationSanityCheckOnFilePlan(NodeRef filePlan) {
        NodeRef result = null;
        if (filePlan == null) {
            result = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() {
                    return RecordServiceImpl.this.filePlanService.getFilePlanBySiteId("rm");
                }
            }, (String)AuthenticationUtil.getAdminUserName());
            if (result == null) {
                String msg = "Cannot create record, because the default file plan cannot be determined. Make sure at least one file plan has been created.";
                LOGGER.debug(msg);
                throw new RecordCreationException(msg);
            }
        } else {
            if (!this.filePlanService.isFilePlan(filePlan)) {
                String msg = "Cannot create record, because the provided file plan node reference is not a file plan.";
                LOGGER.debug(msg);
                throw new RecordCreationException(msg);
            }
            result = filePlan;
        }
        return result;
    }

    private NodeRef recordCreationSanityCheckOnDestinationNode(NodeRef destinationNodeRef, NodeRef filePlan) {
        NodeRef checkedFilePlan = this.recordCreationSanityCheckOnFilePlan(filePlan);
        NodeRef newRecordContainer = destinationNodeRef;
        if (newRecordContainer == null) {
            newRecordContainer = (NodeRef)AuthenticationUtil.runAsSystem(() -> this.filePlanService.getUnfiledContainer(checkedFilePlan));
            if (newRecordContainer == null) {
                throw new AlfrescoRuntimeException("Unable to create record, because record container could not be found.");
            }
        } else {
            QName nodeType = this.nodeService.getType(newRecordContainer);
            if (!(nodeType.equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER) || nodeType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER) || nodeType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER))) {
                throw new AlfrescoRuntimeException("Unable to create record, because container is not a valid type for new record.");
            }
            Boolean isClosed = (Boolean)this.nodeService.getProperty(newRecordContainer, PROP_IS_CLOSED);
            if (isClosed != null && isClosed.booleanValue()) {
                throw new IntegrityException(I18NUtil.getMessage((String)MSG_CANNOT_CREATE_CHILDREN_IN_CLOSED_RECORD_FOLDER), null);
            }
            if (this.extendedPermissionService.hasPermission(newRecordContainer, "Filing") == AccessStatus.DENIED) {
                throw new AccessDeniedException(I18NUtil.getMessage((String)"permissions.err_access_denied"));
            }
            if (this.freezeService.isFrozen(newRecordContainer)) {
                throw new IntegrityException(I18NUtil.getMessage((String)"rm.service.add-children-to-frozen-record-folder"), null);
            }
        }
        return newRecordContainer;
    }

    private void recordCreationSanityCheckOnNode(NodeRef nodeRef) {
        if (this.extendedPermissionService.hasPermission(nodeRef, "Write") != AccessStatus.ALLOWED) {
            String msg = "Cannot create record from document, because the user " + AuthenticationUtil.getRunAsUser() + " does not have Write permissions on the doucment " + nodeRef.toString();
            LOGGER.debug(msg);
            throw new AccessDeniedException(msg);
        }
        if (!this.nodeService.exists(nodeRef)) {
            String msg = "Cannot create record, because " + nodeRef.toString() + " does not exist.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
        if (!this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT)) {
            String msg = "Cannot create record, because " + nodeRef.toString() + " is not a supported type.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
        if (this.nodeService.hasAspect(nodeRef, ASPECT_RECORD)) {
            String msg = "Cannot create record, because " + nodeRef.toString() + " is already a record.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            String msg = "Can node create record, because " + nodeRef.toString() + " is a working copy.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
        if (this.nodeService.hasAspect(nodeRef, ASPECT_RECORD_REJECTION_DETAILS)) {
            String msg = "Cannot create record, because " + nodeRef.toString() + " has previously been rejected.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
        if (this.nodeService.hasAspect(nodeRef, ASPECT_SYNCED)) {
            String msg = "Can't declare as record, because " + nodeRef.toString() + " is synched content.";
            LOGGER.debug(msg);
            throw new RecordCreationException(msg);
        }
    }

    @Override
    public NodeRef createRecordFromCopy(final NodeRef filePlan, final NodeRef nodeRef) {
        return this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public NodeRef doWork() throws Exception {
                NodeRef unfiledRecordFolder = RecordServiceImpl.this.filePlanService.getUnfiledContainer(filePlan);
                Pair<Set<String>, Set<String>> readersAndWriters = RecordServiceImpl.this.extendedPermissionService.getReadersAndWriters(nodeRef);
                NodeRef record = null;
                try {
                    List originalAssocs = null;
                    if (RecordServiceImpl.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM)) {
                        originalAssocs = RecordServiceImpl.this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
                    }
                    RecordServiceImpl.this.recordsManagementContainerType.disable();
                    try {
                        FileInfo recordInfo = RecordServiceImpl.this.fileFolderService.copy(nodeRef, unfiledRecordFolder, null);
                        record = recordInfo.getNodeRef();
                    }
                    finally {
                        RecordServiceImpl.this.recordsManagementContainerType.enable();
                    }
                    RecordServiceImpl.this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    try {
                        RecordServiceImpl.this.nodeService.removeAspect(record, ContentModel.ASPECT_VERSIONABLE);
                    }
                    finally {
                        RecordServiceImpl.this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    }
                    RecordServiceImpl.this.makeRecord(record);
                    RecordUtils.generateRecordIdentifier(RecordServiceImpl.this.nodeService, RecordServiceImpl.this.identifierService, record);
                    List recordAssocs = RecordServiceImpl.this.nodeService.getTargetAssocs(record, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
                    for (AssociationRef recordAssoc : recordAssocs) {
                        RecordServiceImpl.this.nodeService.removeAssociation(recordAssoc.getSourceRef(), recordAssoc.getTargetRef(), ContentModel.ASSOC_ORIGINAL);
                    }
                    if (originalAssocs == null) {
                        RecordServiceImpl.this.nodeService.removeAspect(record, ContentModel.ASPECT_COPIEDFROM);
                    } else {
                        for (AssociationRef originalAssoc : originalAssocs) {
                            RecordServiceImpl.this.nodeService.createAssociation(record, originalAssoc.getTargetRef(), ContentModel.ASSOC_ORIGINAL);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    throw new AlfrescoRuntimeException("Can't create recorded version, because copy fails.", (Throwable)e);
                }
                RecordServiceImpl.this.extendedSecurityService.set(record, readersAndWriters);
                return record;
            }
        });
    }

    private NodeRef getLatestVersionRecord(NodeRef nodeRef) {
        NodeRef versionRecord = null;
        this.recordableVersionService.createSnapshotVersion(nodeRef);
        VersionHistory versionHistory = this.versionService.getVersionHistory(nodeRef);
        if (versionHistory != null) {
            Collection previousVersions = versionHistory.getAllVersions();
            for (Version previousVersion : previousVersions) {
                NodeRef previousRecord = this.recordableVersionService.getVersionRecord(previousVersion);
                if (previousRecord == null) continue;
                versionRecord = previousRecord;
                break;
            }
        }
        return versionRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef createRecordFromContent(NodeRef parent, String name, QName type, Map<QName, Serializable> properties, ContentReader reader) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)parent);
        ParameterCheck.mandatory((String)"name", (Object)name);
        NodeRef result = null;
        NodeRef destination = parent;
        if (this.isFilePlan(parent) && (destination = this.filePlanService.getUnfiledContainer(parent)) == null) {
            throw new AlfrescoRuntimeException("Unable to create record, because unfiled container could not be found.");
        }
        if (type == null) {
            type = ContentModel.TYPE_CONTENT;
        } else if (!this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
            throw new AlfrescoRuntimeException("Record can only be created from a sub-type of cm:content.");
        }
        this.disablePropertyEditableCheck();
        try {
            final NodeRef record = this.fileFolderService.create(destination, name, type).getNodeRef();
            if (properties != null) {
                this.nodeService.addProperties(record, properties);
            }
            if (reader != null) {
                ContentWriter writer = this.fileFolderService.getWriter(record);
                writer.setEncoding(reader.getEncoding());
                writer.setMimetype(reader.getMimetype());
                writer.putContent(reader);
            }
            result = this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    if (!RecordServiceImpl.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD)) {
                        RecordServiceImpl.this.makeRecord(record);
                        RecordUtils.generateRecordIdentifier(RecordServiceImpl.this.nodeService, RecordServiceImpl.this.identifierService, record);
                    }
                    return record;
                }
            });
        }
        finally {
            this.enablePropertyEditableCheck();
        }
        return result;
    }

    @Override
    public void makeRecord(final NodeRef document) {
        ParameterCheck.mandatory((String)"document", (Object)document);
        this.ruleService.disableRules();
        this.disablePropertyEditableCheck();
        try {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    RecordServiceImpl.this.nodeService.addAspect(document, RecordsManagementModel.ASPECT_RECORD, null);
                    RecordServiceImpl.this.nodeService.removeAspect(document, RecordableVersionModel.ASPECT_VERSIONABLE);
                    RecordServiceImpl.this.ownableService.setOwner(document, "");
                    return null;
                }
            });
        }
        finally {
            this.ruleService.enableRules();
            this.enablePropertyEditableCheck();
        }
    }

    @Override
    public boolean isFiled(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        boolean result = false;
        if (this.isRecord(nodeRef)) {
            result = (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return null != RecordServiceImpl.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_DATE_FILED);
                }
            });
        }
        return result;
    }

    @Override
    public void file(NodeRef record) {
        ParameterCheck.mandatory((String)"item", (Object)record);
        QName type = this.nodeService.getType(record);
        if (ContentModel.TYPE_CONTENT.equals((Object)type) || this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
            ((RecordsManagementPolicies.BeforeFileRecord)this.beforeFileRecord.get(this.getTypeAndApsects(record))).beforeFileRecord(record);
            if (!this.isRecord(record)) {
                this.makeRecord(record);
            }
            if (this.nodeService.getProperty(record, PROP_DATE_FILED) == null) {
                Calendar fileCalendar = Calendar.getInstance();
                this.nodeService.setProperty(record, PROP_DATE_FILED, (Serializable)fileCalendar.getTime());
            }
            ((RecordsManagementPolicies.OnFileRecord)this.onFileRecord.get(this.getTypeAndApsects(record))).onFileRecord(record);
        }
    }

    @Override
    public void rejectRecord(final NodeRef nodeRef, final String reason) {
        ParameterCheck.mandatory((String)"NodeRef", (Object)nodeRef);
        ParameterCheck.mandatoryString((String)"Reason", (String)reason);
        final String userId = AuthenticationUtil.getFullyAuthenticatedUser();
        this.invokeBeforeRecordRejection(nodeRef);
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() throws Exception {
                RecordServiceImpl.this.ruleService.disableRules();
                try {
                    NodeRef latestVersionRecord = RecordServiceImpl.this.getLatestVersionRecord(nodeRef);
                    if (latestVersionRecord != null) {
                        RecordServiceImpl.this.relationshipService.removeRelationship(RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName(), nodeRef, latestVersionRecord);
                    }
                    Map properties = RecordServiceImpl.this.nodeService.getProperties(nodeRef);
                    String recordId = (String)properties.get(RecordsManagementModel.PROP_IDENTIFIER);
                    String documentOwner = (String)properties.get(RecordsManagementModel.PROP_RECORD_ORIGINATING_USER_ID);
                    String originalName = (String)properties.get(RecordsManagementModel.PROP_ORIGIONAL_NAME);
                    NodeRef originatingLocation = (NodeRef)properties.get(RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION);
                    if (originatingLocation != null) {
                        List parentAssocs = RecordServiceImpl.this.nodeService.getParentAssocs(nodeRef);
                        for (ChildAssociationRef childAssociationRef : parentAssocs) {
                            if (childAssociationRef.isPrimary() || !childAssociationRef.getParentRef().equals((Object)originatingLocation) && !RecordServiceImpl.this.nodeService.getType(childAssociationRef.getParentRef()).equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER)) continue;
                            RecordServiceImpl.this.nodeService.removeChildAssociation(childAssociationRef);
                        }
                        this.removeRmAspectsFrom(nodeRef);
                        ChildAssociationRef parentAssoc = RecordServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
                        RecordServiceImpl.this.nodeService.moveNode(nodeRef, originatingLocation, ContentModel.ASSOC_CONTAINS, parentAssoc.getQName());
                        if (originalName != null) {
                            RecordServiceImpl.this.fileFolderService.rename(nodeRef, originalName);
                            String name = (String)((Object)RecordServiceImpl.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                            LOGGER.debug("Rename {} to {}", (Object)name, (Object)originalName);
                        }
                        HashMap<QName, Object> aspectProperties = new HashMap<QName, Object>(3);
                        aspectProperties.put(RecordsManagementModel.PROP_RECORD_REJECTION_USER_ID, userId);
                        aspectProperties.put(RecordsManagementModel.PROP_RECORD_REJECTION_DATE, new Date());
                        aspectProperties.put(RecordsManagementModel.PROP_RECORD_REJECTION_REASON, reason);
                        RecordServiceImpl.this.nodeService.addAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD_REJECTION_DETAILS, aspectProperties);
                        if (StringUtils.isBlank((CharSequence)documentOwner)) {
                            throw new AlfrescoRuntimeException("Unable to find the creator of document.");
                        }
                        RecordServiceImpl.this.ownableService.setOwner(nodeRef, documentOwner);
                        RecordServiceImpl.this.permissionService.clearPermission(nodeRef, null);
                        RecordServiceImpl.this.permissionService.setInheritParentPermissions(nodeRef, true);
                        RecordServiceImpl.this.notificationHelper.recordRejectedEmailNotification(nodeRef, recordId, documentOwner);
                    }
                }
                finally {
                    RecordServiceImpl.this.ruleService.enableRules();
                }
                return null;
            }

            private void removeRmAspectsFrom(NodeRef nodeRef2) {
                Set aspects = RecordServiceImpl.this.nodeService.getAspects(nodeRef2);
                List<String> rmURIs = Arrays.asList("http://www.alfresco.org/model/recordsmanagement/1.0", "http://www.alfresco.org/model/dod5015/1.0", "http://www.alfresco.org/model/rmcustom/1.0", "http://www.alfresco.org/model/recordableversion/1.0");
                for (QName aspect : aspects) {
                    if (!rmURIs.contains(aspect.getNamespaceURI())) continue;
                    RecordServiceImpl.this.nodeService.removeAspect(nodeRef2, aspect);
                }
                for (ChildAssociationRef renditionAssoc : RecordServiceImpl.this.renditionService.getRenditions(nodeRef2)) {
                    NodeRef renditionNode = renditionAssoc.getChildRef();
                    boolean renditionRequiresCleaning = RecordServiceImpl.this.nodeService.exists(renditionNode) && renditionAssoc.isPrimary();
                    if (!renditionRequiresCleaning) continue;
                    this.removeRmAspectsFrom(renditionNode);
                }
            }
        });
        this.invokeOnRecordRejection(nodeRef);
    }

    @Override
    public boolean isPropertyEditable(NodeRef record, QName property) {
        boolean result;
        ParameterCheck.mandatory((String)"record", (Object)record);
        ParameterCheck.mandatory((String)"property", (Object)property);
        if (!this.isRecord(record)) {
            throw new AlfrescoRuntimeException("Cannot check if the property " + property.toString() + " is editable, because node reference is not a record.");
        }
        NodeRef filePlan = this.getFilePlan(record);
        boolean debugEnabled = LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug("Checking whether property " + property.toString() + " is editable for user " + AuthenticationUtil.getRunAsUser());
            Set<Role> roles = this.filePlanRoleService.getRolesByUser(filePlan, AuthenticationUtil.getRunAsUser());
            LOGGER.debug(" ... users roles");
            for (Role role : roles) {
                LOGGER.debug("     ... user has role " + role.getName() + " with capabilities ");
                for (Capability cap : role.getCapabilities()) {
                    LOGGER.debug("         ... " + cap.getName());
                }
            }
            LOGGER.debug(" ... user has the following set permissions on the file plan");
            Set perms = this.permissionService.getAllSetPermissions(filePlan);
            for (AccessPermission perm : perms) {
                if (!perm.getPermission().contains("EditNonRecordMetadata") && !perm.getPermission().contains("EditRecordMetadata")) continue;
                LOGGER.debug("     ... " + perm.getAuthority() + " - " + perm.getPermission() + " - " + perm.getAccessStatus().toString());
            }
            if (this.permissionService.hasPermission(filePlan, "EditNonRecordMetadata").equals((Object)AccessStatus.ALLOWED)) {
                LOGGER.debug(" ... user has the edit non record metadata permission on the file plan");
            }
        }
        if (result = this.alwaysEditProperty(property)) {
            LOGGER.debug(" ... property marked as always editable.");
        } else {
            boolean bl;
            boolean allowRecordEdit = false;
            boolean bl2 = false;
            AccessStatus accessNonRecord = this.capabilityService.getCapabilityAccessState(record, "EditNonRecordMetadata");
            AccessStatus accessDeclaredRecord = this.capabilityService.getCapabilityAccessState(record, "EditDeclaredRecordMetadata");
            AccessStatus accessRecord = this.capabilityService.getCapabilityAccessState(record, "EditRecordMetadata");
            if (AccessStatus.ALLOWED.equals((Object)accessNonRecord)) {
                LOGGER.debug(" ... user has edit nonrecord metadata capability");
                bl = true;
            }
            if (AccessStatus.ALLOWED.equals((Object)accessRecord) || AccessStatus.ALLOWED.equals((Object)accessDeclaredRecord)) {
                LOGGER.debug(" ... user has edit record or declared metadata capability");
                allowRecordEdit = true;
            }
            if (bl && allowRecordEdit) {
                LOGGER.debug(" ... so all properties can be edited.");
                result = true;
            } else if (bl && !allowRecordEdit) {
                if (!this.isRecordMetadata(filePlan, property)) {
                    LOGGER.debug(" ... property is not considered record metadata so editable.");
                    result = true;
                } else {
                    LOGGER.debug(" ... property is considered record metadata so not editable.");
                }
            } else if (!bl && allowRecordEdit) {
                if (this.isRecordMetadata(filePlan, property)) {
                    LOGGER.debug(" ... property is considered record metadata so editable.");
                    result = true;
                } else {
                    LOGGER.debug(" ... property is not considered record metadata so not editable.");
                }
            }
        }
        return result;
    }

    private boolean isRecordMetadata(NodeRef filePlan, QName property) {
        boolean result = false;
        ClassDefinition parent = null;
        PropertyDefinition def = this.dictionaryService.getProperty(property);
        if (def != null) {
            parent = def.getContainerClass();
        }
        if (parent != null && TYPE_NON_ELECTRONIC_DOCUMENT.equals((Object)parent.getName())) {
            result = false;
        } else {
            result = this.recordModelURIs.contains(property.getNamespaceURI());
            if (!result && !ArrayUtils.contains((Object[])NON_RECORD_MODEL_URIS, (Object)property.getNamespaceURI()) && parent != null && parent.isAspect()) {
                result = this.getRecordMetadataAspects(filePlan).contains(parent.getName());
            }
        }
        return result;
    }

    private boolean alwaysEditProperty(QName property) {
        return this.getAlwaysEditURIs().contains(property.getNamespaceURI()) || ArrayUtils.contains((Object[])ALWAYS_EDIT_PROPERTIES, (Object)property) || this.isProtectedProperty(property);
    }

    private boolean isProtectedProperty(QName property) {
        boolean result = false;
        PropertyDefinition def = this.dictionaryService.getProperty(property);
        if (def != null) {
            result = def.isProtected();
        }
        return result;
    }

    @Override
    public boolean isMetadataStub(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.nodeService.hasAspect(nodeRef, ASPECT_GHOSTED);
    }

    @Override
    public List<NodeRef> getRecords(NodeRef recordFolder) {
        ParameterCheck.mandatory((String)"recordFolder", (Object)recordFolder);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(1);
        if (this.recordFolderService.isRecordFolder(recordFolder)) {
            List assocs = this.nodeService.getChildAssocs(recordFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef assoc : assocs) {
                NodeRef child = assoc.getChildRef();
                if (!this.isRecord(child)) continue;
                result.add(child);
            }
        }
        return result;
    }

    @Override
    public void addRecordType(NodeRef nodeRef, QName typeQName) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"typeQName", (Object)typeQName);
        if (!this.nodeService.hasAspect(nodeRef, typeQName)) {
            this.nodeService.addAspect(nodeRef, typeQName, null);
        } else {
            LOGGER.info(I18NUtil.getMessage((String)MSG_NODE_HAS_ASPECT, (Object[])new Object[]{nodeRef.toString(), typeQName.toString()}));
        }
    }

    @Override
    public void link(NodeRef record, NodeRef recordFolder) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        ParameterCheck.mandatory((String)"recordFolder", (Object)recordFolder);
        if (this.isRecord(record) && this.isRecordFolder(recordFolder)) {
            List parents = this.nodeService.getParentAssocs(record);
            for (ChildAssociationRef parent : parents) {
                if (!parent.getParentRef().equals((Object)recordFolder)) continue;
                throw new RecordLinkRuntimeException("Cannot link a record to the same record folder more than once");
            }
        } else {
            throw new RecordLinkRuntimeException("Can only link a record to a record folder.");
        }
        this.validateLinkConditions(record, recordFolder);
        String name = this.nodeService.getProperty(record, ContentModel.PROP_NAME).toString();
        this.nodeService.addChild(recordFolder, record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name));
        this.dispositionService.recalculateNextDispositionStep(record);
    }

    private void validateLinkConditions(NodeRef record, NodeRef recordFolder) {
        DispositionSchedule recordFolderDispositionSchedule;
        DispositionSchedule recordDispositionSchedule = this.dispositionService.getOriginDispositionSchedule(record);
        if (recordDispositionSchedule != null && (recordFolderDispositionSchedule = this.dispositionService.getDispositionSchedule(recordFolder)) != null && recordDispositionSchedule.isRecordLevelDisposition() != recordFolderDispositionSchedule.isRecordLevelDisposition()) {
            throw new RecordLinkRuntimeException("Cannot link a record to a record folder with an incompatible retention schedule.  They must either both be record level or record folder level retentions.");
        }
    }

    @Override
    public void unlink(NodeRef record, NodeRef recordFolder) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        ParameterCheck.mandatory((String)"recordFolder", (Object)recordFolder);
        if (this.isRecord(record) && this.isRecordFolder(recordFolder)) {
            NodeRef primaryParent = this.nodeService.getPrimaryParent(record).getParentRef();
            if (primaryParent.equals((Object)recordFolder)) {
                throw new RecordLinkRuntimeException("Can't unlink a record from it's owning record folder.");
            }
        } else {
            throw new RecordLinkRuntimeException("Can only unlink a record from a record folder.");
        }
        this.nodeService.removeChild(recordFolder, record);
        this.dispositionService.recalculateNextDispositionStep(record);
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            RecordUtils.generateRecordIdentifier(this.nodeService, this.identifierService, nodeRef);
            this.reevaluateIncompleteTag(nodeRef);
        }
    }

    protected void invokeBeforeRecordDeclaration(NodeRef nodeRef) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.nodeService, nodeRef);
        RecordsManagementPolicies.BeforeRecordDeclaration policy = (RecordsManagementPolicies.BeforeRecordDeclaration)this.beforeRecordDeclarationDelegate.get(qnames);
        policy.beforeRecordDeclaration(nodeRef);
    }

    protected void invokeOnRecordDeclaration(NodeRef nodeRef) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.nodeService, nodeRef);
        RecordsManagementPolicies.OnRecordDeclaration policy = (RecordsManagementPolicies.OnRecordDeclaration)this.onRecordDeclarationDelegate.get(qnames);
        policy.onRecordDeclaration(nodeRef);
    }

    protected void invokeBeforeRecordRejection(NodeRef nodeRef) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.nodeService, nodeRef);
        RecordsManagementPolicies.BeforeRecordRejection policy = (RecordsManagementPolicies.BeforeRecordRejection)this.beforeRecordRejectionDelegate.get(qnames);
        policy.beforeRecordRejection(nodeRef);
    }

    protected void invokeOnRecordRejection(NodeRef nodeRef) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.nodeService, nodeRef);
        RecordsManagementPolicies.OnRecordRejection policy = (RecordsManagementPolicies.OnRecordRejection)this.onRecordRejectionDelegate.get(qnames);
        policy.onRecordRejection(nodeRef);
    }

    private void reevaluateIncompleteTag(NodeRef nodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE)) {
            this.incompleteNodeTagger.beforeCommit(false);
        }
    }

    @Override
    public void complete(final NodeRef nodeRef) {
        this.validateForCompletion(nodeRef);
        this.disablePropertyEditableCheck();
        try {
            HashMap<QName, Object> declaredProps = new HashMap<QName, Object>(2);
            declaredProps.put(PROP_DECLARED_AT, new Date());
            declaredProps.put(PROP_DECLARED_BY, AuthenticationUtil.getRunAsUser());
            this.nodeService.addAspect(nodeRef, ASPECT_DECLARED_RECORD, declaredProps);
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    RecordServiceImpl.this.ownableService.setOwner(nodeRef, "");
                    return null;
                }
            });
        }
        finally {
            this.enablePropertyEditableCheck();
        }
    }

    private void validateForCompletion(NodeRef nodeRef) {
        if (!this.nodeService.exists(nodeRef)) {
            LOGGER.warn(I18NUtil.getMessage((String)MSG_UNDECLARED_ONLY_RECORDS, (Object[])new Object[]{nodeRef.toString()}));
            throw new IntegrityException("The record does not exist.", null);
        }
        if (!this.isRecord(nodeRef)) {
            LOGGER.warn(I18NUtil.getMessage((String)MSG_UNDECLARED_ONLY_RECORDS, (Object[])new Object[]{nodeRef.toString()}));
            throw new IntegrityException("The node is not a record.", null);
        }
        if (this.freezeService.isFrozen(nodeRef)) {
            LOGGER.warn(I18NUtil.getMessage((String)MSG_UNDECLARED_ONLY_RECORDS, (Object[])new Object[]{nodeRef.toString()}));
            throw new IntegrityException("The record is frozen.", null);
        }
        if (this.isDeclared(nodeRef)) {
            throw new IntegrityException("The record is already completed.", null);
        }
        Set newRecords = this.transactionalResourceHelper.getSet(KEY_NEW_RECORDS);
        if (newRecords.contains(nodeRef)) {
            RecordUtils.generateRecordIdentifier(this.nodeService, this.identifierService, nodeRef);
        }
        ArrayList<String> missingProperties = new ArrayList<String>(5);
        if (this.checkMandatoryPropertiesEnabled) {
            Map nodeRefProps = this.nodeService.getProperties(nodeRef);
            QName nodeRefType = this.nodeService.getType(nodeRef);
            TypeDefinition typeDef = this.dictionaryService.getType(nodeRefType);
            this.checkDefinitionMandatoryPropsSet((ClassDefinition)typeDef, nodeRefProps, missingProperties);
            Set aspects = this.nodeService.getAspects(nodeRef);
            for (QName aspect : aspects) {
                AspectDefinition aspectDef = this.dictionaryService.getAspect(aspect);
                this.checkDefinitionMandatoryPropsSet((ClassDefinition)aspectDef, nodeRefProps, missingProperties);
            }
            QName customAspect = this.getCustomAspectImpl(nodeRefType);
            AspectDefinition aspectDef = this.dictionaryService.getAspect(customAspect);
            this.checkDefinitionMandatoryPropsSet((ClassDefinition)aspectDef, nodeRefProps, missingProperties);
            if (!missingProperties.isEmpty()) {
                LOGGER.debug(this.buildMissingPropertiesErrorString(missingProperties));
                throw new RecordMissingMetadataException("The record has missing mandatory properties.");
            }
        }
    }

    private String buildMissingPropertiesErrorString(List<String> missingProperties) {
        StringBuilder builder = new StringBuilder(255);
        builder.append(I18NUtil.getMessage((String)MSG_NO_DECLARE_MAND_PROP));
        builder.append("  ");
        for (String missingProperty : missingProperties) {
            builder.append(missingProperty).append(", ");
        }
        return builder.toString();
    }

    private void checkDefinitionMandatoryPropsSet(ClassDefinition classDef, Map<QName, Serializable> nodeRefProps, List<String> missingProperties) {
        for (PropertyDefinition propDef : classDef.getProperties().values()) {
            if (!propDef.isMandatory() || nodeRefProps.get(propDef.getName()) != null) continue;
            if (LOGGER.isWarnEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Mandatory property missing: ").append(propDef.getName());
                LOGGER.warn(msg.toString());
            }
            missingProperties.add(propDef.getName().toString());
        }
    }

    private QName getCustomAspectImpl(QName nodeRefType) {
        QName aspect = ASPECT_RECORD;
        if (nodeRefType.equals((Object)TYPE_NON_ELECTRONIC_DOCUMENT)) {
            aspect = TYPE_NON_ELECTRONIC_DOCUMENT;
        }
        String localName = aspect.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "");
        localName = MessageFormat.format("{0}CustomProperties", localName);
        return QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)localName);
    }
}

