/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v20;

import java.io.Serializable;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.compatibility.ModulePatchComponent;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.Pair;
import org.springframework.beans.factory.BeanNameAware;

public class RMv2FilePlanNodeRefPatch
extends ModulePatchComponent
implements BeanNameAware,
RecordsManagementModel,
DOD5015Model {
    private NodeService nodeService;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private PermissionService permissionService;
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Override
    protected void executePatch() {
        Pair aspectPair = this.qnameDAO.getQName(RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
        if (aspectPair != null) {
            List filePlanComponents = this.patchDAO.getNodesByAspectQNameId((Long)aspectPair.getFirst(), Long.valueOf(0L), Long.valueOf(this.patchDAO.getMaxAdmNodeID()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("   ... updating " + filePlanComponents.size() + " items");
            }
            for (Long filePlanComponent : filePlanComponents) {
                Pair recordPair = this.nodeDAO.getNodePair(filePlanComponent);
                NodeRef filePlanComponentNodeRef = (NodeRef)recordPair.getSecond();
                NodeRef filePlan = this.filePlanService.getFilePlan(filePlanComponentNodeRef);
                if (filePlan != null) {
                    Serializable reviewPeriod;
                    Serializable vitalRecordIndicator;
                    FilePlanComponentKind kind;
                    if (this.nodeService.getProperty(filePlanComponentNodeRef, PROP_ROOT_NODEREF) == null) {
                        this.nodeService.setProperty(filePlanComponentNodeRef, PROP_ROOT_NODEREF, (Serializable)filePlan);
                    }
                    if (!FilePlanComponentKind.RECORD_CATEGORY.equals((Object)(kind = this.filePlanService.getFilePlanComponentKind(filePlanComponentNodeRef))) && !FilePlanComponentKind.RECORD_FOLDER.equals((Object)kind) && !FilePlanComponentKind.RECORD.equals((Object)kind)) continue;
                    Role adminRole = this.filePlanRoleService.getRole(filePlan, "Administrator");
                    if (adminRole != null) {
                        this.permissionService.setPermission(filePlanComponentNodeRef, adminRole.getRoleGroupName(), "Filing", true);
                    }
                    if ((vitalRecordIndicator = this.nodeService.getProperty(filePlanComponentNodeRef, PROP_VITAL_RECORD_INDICATOR)) == null) {
                        this.nodeService.setProperty(filePlanComponentNodeRef, PROP_VITAL_RECORD_INDICATOR, (Serializable)Boolean.valueOf(false));
                    }
                    if ((reviewPeriod = this.nodeService.getProperty(filePlanComponentNodeRef, PROP_REVIEW_PERIOD)) != null) continue;
                    this.nodeService.setProperty(filePlanComponentNodeRef, PROP_REVIEW_PERIOD, (Serializable)new Period("none|0"));
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("   ... node " + filePlanComponent.toString() + " was skiped, beacuse there was no associated file plan.");
            }
        }
    }
}

