/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.rule;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.springframework.extensions.webscripts.GUID;

public class FilePlanRuleInheritanceTest
extends BaseRMTestCase {
    private RuleService ruleService;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isRMSiteTest() {
        return false;
    }

    private NodeRef createFilePlan() {
        return this.filePlanService.createFilePlan(this.folder, "My File Plan");
    }

    public void testFilePlanDoesNotInheritRulesFromParentFolder() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef filePlan;
            private Rule rule;
            private List<Rule> rules;
            {
                this.filePlan = null;
                this.rule = null;
                this.rules = null;
            }

            @Override
            public void given() {
                this.filePlan = FilePlanRuleInheritanceTest.this.createFilePlan();
                this.rule = FilePlanRuleInheritanceTest.this.createRuleThatAppliesToChildren();
            }

            @Override
            public void when() {
                FilePlanRuleInheritanceTest.this.ruleService.saveRule(FilePlanRuleInheritanceTest.this.folder, this.rule);
            }

            @Override
            public void then() {
                this.rules = FilePlanRuleInheritanceTest.this.ruleService.getRules(this.filePlan, true);
                TestCase.assertEquals((int)0, (int)this.rules.size());
            }
        });
    }

    public void testFilePlanRulesInheritedInUnfiledContainer() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef filePlan;
            private List<Rule> rules;
            private Rule rule;
            {
                this.filePlan = null;
                this.rules = null;
                this.rule = null;
            }

            @Override
            public void given() {
                this.filePlan = FilePlanRuleInheritanceTest.this.createFilePlan();
                this.rule = FilePlanRuleInheritanceTest.this.createRuleThatAppliesToChildren();
            }

            @Override
            public void when() {
                FilePlanRuleInheritanceTest.this.ruleService.saveRule(this.filePlan, this.rule);
            }

            @Override
            public void then() {
                NodeRef unfiledRecordContainer = FilePlanRuleInheritanceTest.this.filePlanService.getUnfiledContainer(this.filePlan);
                this.rules = FilePlanRuleInheritanceTest.this.ruleService.getRules(unfiledRecordContainer, true);
                TestCase.assertEquals((int)0, (int)this.rules.size());
            }
        });
    }

    public void testFilePlanRulesInheritedInHoldContainer() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef filePlan;
            private List<Rule> rules;
            private Rule rule;
            {
                this.filePlan = null;
                this.rules = null;
                this.rule = null;
            }

            @Override
            public void given() {
                this.filePlan = FilePlanRuleInheritanceTest.this.createFilePlan();
                this.rule = FilePlanRuleInheritanceTest.this.createRuleThatAppliesToChildren();
            }

            @Override
            public void when() {
                FilePlanRuleInheritanceTest.this.ruleService.saveRule(this.filePlan, this.rule);
            }

            @Override
            public void then() {
                NodeRef container = FilePlanRuleInheritanceTest.this.filePlanService.getHoldContainer(this.filePlan);
                this.rules = FilePlanRuleInheritanceTest.this.ruleService.getRules(container, true);
                TestCase.assertEquals((int)0, (int)this.rules.size());
            }
        });
    }

    public void testFilePlanRulesInheritedInTransferContainer() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef filePlan;
            private List<Rule> rules;
            private Rule rule;
            {
                this.filePlan = null;
                this.rules = null;
                this.rule = null;
            }

            @Override
            public void given() {
                this.filePlan = FilePlanRuleInheritanceTest.this.createFilePlan();
                this.rule = FilePlanRuleInheritanceTest.this.createRuleThatAppliesToChildren();
            }

            @Override
            public void when() {
                FilePlanRuleInheritanceTest.this.ruleService.saveRule(this.filePlan, this.rule);
            }

            @Override
            public void then() {
                NodeRef container = FilePlanRuleInheritanceTest.this.filePlanService.getTransferContainer(this.filePlan);
                this.rules = FilePlanRuleInheritanceTest.this.ruleService.getRules(container, true);
                TestCase.assertEquals((int)0, (int)this.rules.size());
            }
        });
    }

    public void testFilePlanRulesInheritedOnRecordCategory() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef filePlan;
            private NodeRef recordCategory;
            private List<Rule> rules;
            private Rule rule;
            {
                this.filePlan = null;
                this.recordCategory = null;
                this.rules = null;
                this.rule = null;
            }

            @Override
            public void given() {
                this.filePlan = FilePlanRuleInheritanceTest.this.createFilePlan();
                this.recordCategory = FilePlanRuleInheritanceTest.this.filePlanService.createRecordCategory(this.filePlan, GUID.generate());
                this.rule = FilePlanRuleInheritanceTest.this.createRuleThatAppliesToChildren();
            }

            @Override
            public void when() {
                FilePlanRuleInheritanceTest.this.ruleService.saveRule(this.filePlan, this.rule);
            }

            @Override
            public void then() {
                this.rules = FilePlanRuleInheritanceTest.this.ruleService.getRules(this.recordCategory, true);
                TestCase.assertEquals((int)1, (int)this.rules.size());
            }
        });
    }

    private Rule createRuleThatAppliesToChildren() {
        Action completeRecordAction = this.actionService.createAction("declareRecord");
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        rule.setTitle("Rule name");
        rule.setAction(completeRecordAction);
        rule.applyToChildren(true);
        return rule;
    }
}

