/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.rest.api.impl.SiteImportPackageHandler;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.RMSitesImpl;
import org.alfresco.rm.rest.api.model.RMSite;
import org.alfresco.rm.rest.api.model.RMSiteCompliance;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RMSitesImplUnitTest
extends BaseUnitTest {
    private static final String RM_SITE_TITLE_AFTER_UPDATE = "Updated Title";
    private static final String RM_SITE_DESCRIPTION_AFTER_UPDATE = "Updated Description";
    private static final String RM_SITE_ID = "rm";
    private static final String RM_SITE_MANAGER_ROLE = "SiteManager";
    private static final String RM_SITE_TITLE = "RM Site Title";
    private static final String RM_SITE_DESCRIPTION = "RM Site Description";
    private static final String RM_SITE_PRESET = "rm-site-dashboard";
    private static final String PARAM_SKIP_ADDTOFAVORITES = "skipAddToFavorites";
    @InjectMocks
    private RMSitesImpl rmSitesImpl;
    @Mock
    private SiteService mockedSiteService;
    @Mock
    private ImporterService mockedImporterService;
    @Mock
    private FavouritesService mockedFavouritesService;

    @Override
    @Before
    public void before() {
    }

    @Test
    public void createRMStandardSite() throws Exception {
        RMSite toCreate = new RMSite();
        toCreate.setTitle(RM_SITE_TITLE);
        toCreate.setDescription(RM_SITE_DESCRIPTION);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        NodeRef siteNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)mockedSiteInfo.getShortName()).thenReturn((Object)RM_SITE_ID);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)siteNodeRef);
        Mockito.when((Object)mockedSiteInfo.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION);
        Mockito.when((Object)mockedSiteInfo.getTitle()).thenReturn((Object)RM_SITE_TITLE);
        Mockito.when((Object)mockedSiteInfo.getVisibility()).thenReturn((Object)SiteVisibility.PUBLIC);
        Mockito.when((Object)this.mockedSiteService.createSite((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (SiteVisibility)ArgumentMatchers.any(SiteVisibility.class), (QName)ArgumentMatchers.any(QName.class))).thenReturn((Object)mockedSiteInfo);
        Parameters mockedParameters = (Parameters)Mockito.mock(Parameters.class);
        RMSite createdRMSite = this.rmSitesImpl.createRMSite(toCreate, mockedParameters);
        ArgumentCaptor sitePresetCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor idCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor titleCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor descriptionCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor visibilityCaptor = ArgumentCaptor.forClass(SiteVisibility.class);
        ArgumentCaptor siteTypeCaptor = ArgumentCaptor.forClass(QName.class);
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createSite((String)sitePresetCaptor.capture(), (String)idCaptor.capture(), (String)titleCaptor.capture(), (String)descriptionCaptor.capture(), (SiteVisibility)visibilityCaptor.capture(), (QName)siteTypeCaptor.capture());
        Assert.assertEquals((Object)RM_SITE_PRESET, (Object)sitePresetCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_ID, (Object)idCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)titleCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)descriptionCaptor.getValue());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)visibilityCaptor.getValue());
        Assert.assertEquals((Object)RecordsManagementModel.TYPE_RM_SITE, (Object)siteTypeCaptor.getValue());
        ((ImporterService)Mockito.verify((Object)this.mockedImporterService, (VerificationMode)Mockito.times((int)1))).importView((ImportPackageHandler)ArgumentMatchers.any(SiteImportPackageHandler.class), (Location)ArgumentMatchers.any(Location.class), (ImporterBinding)ArgumentMatchers.any(ImporterBinding.class), (ImporterProgress)ArgumentMatchers.eq(null));
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createContainer(RM_SITE_ID, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        ((FavouritesService)Mockito.verify((Object)this.mockedFavouritesService, (VerificationMode)Mockito.times((int)1))).addFavourite((String)ArgumentMatchers.nullable(String.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
        Assert.assertEquals((Object)RMSiteCompliance.STANDARD, (Object)createdRMSite.getCompliance());
        Assert.assertEquals(null, (Object)createdRMSite.getRole());
        Assert.assertEquals((Object)RM_SITE_ID, (Object)createdRMSite.getId());
        Assert.assertEquals((Object)siteNodeRef.getId(), (Object)createdRMSite.getGuid());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)createdRMSite.getDescription());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)createdRMSite.getTitle());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)createdRMSite.getVisibility());
    }

    @Test
    public void createRMDOD5015Site() throws Exception {
        RMSite toCreate = new RMSite();
        toCreate.setTitle(RM_SITE_TITLE);
        toCreate.setDescription(RM_SITE_DESCRIPTION);
        toCreate.setCompliance(RMSiteCompliance.DOD5015);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        NodeRef siteNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)mockedSiteInfo.getShortName()).thenReturn((Object)RM_SITE_ID);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)siteNodeRef);
        Mockito.when((Object)mockedSiteInfo.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION);
        Mockito.when((Object)mockedSiteInfo.getTitle()).thenReturn((Object)RM_SITE_TITLE);
        Mockito.when((Object)mockedSiteInfo.getVisibility()).thenReturn((Object)SiteVisibility.PUBLIC);
        Mockito.when((Object)this.mockedSiteService.createSite((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (SiteVisibility)ArgumentMatchers.any(SiteVisibility.class), (QName)ArgumentMatchers.any(QName.class))).thenReturn((Object)mockedSiteInfo);
        Parameters mockedParameters = (Parameters)Mockito.mock(Parameters.class);
        RMSite createdRMSite = this.rmSitesImpl.createRMSite(toCreate, mockedParameters);
        ArgumentCaptor sitePresetCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor idCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor titleCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor descriptionCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor visibilityCaptor = ArgumentCaptor.forClass(SiteVisibility.class);
        ArgumentCaptor siteTypeCaptor = ArgumentCaptor.forClass(QName.class);
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createSite((String)sitePresetCaptor.capture(), (String)idCaptor.capture(), (String)titleCaptor.capture(), (String)descriptionCaptor.capture(), (SiteVisibility)visibilityCaptor.capture(), (QName)siteTypeCaptor.capture());
        Assert.assertEquals((Object)RM_SITE_PRESET, (Object)sitePresetCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_ID, (Object)idCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)titleCaptor.getValue());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)descriptionCaptor.getValue());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)visibilityCaptor.getValue());
        Assert.assertEquals((Object)DOD5015Model.TYPE_DOD_5015_SITE, (Object)siteTypeCaptor.getValue());
        ((ImporterService)Mockito.verify((Object)this.mockedImporterService, (VerificationMode)Mockito.times((int)1))).importView((ImportPackageHandler)ArgumentMatchers.any(SiteImportPackageHandler.class), (Location)ArgumentMatchers.any(Location.class), (ImporterBinding)ArgumentMatchers.any(ImporterBinding.class), (ImporterProgress)ArgumentMatchers.eq(null));
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createContainer(RM_SITE_ID, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        ((FavouritesService)Mockito.verify((Object)this.mockedFavouritesService, (VerificationMode)Mockito.times((int)1))).addFavourite((String)ArgumentMatchers.nullable(String.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
        Assert.assertEquals((Object)RMSiteCompliance.DOD5015, (Object)createdRMSite.getCompliance());
        Assert.assertEquals(null, (Object)createdRMSite.getRole());
        Assert.assertEquals((Object)RM_SITE_ID, (Object)createdRMSite.getId());
        Assert.assertEquals((Object)siteNodeRef.getId(), (Object)createdRMSite.getGuid());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)createdRMSite.getDescription());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)createdRMSite.getTitle());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)createdRMSite.getVisibility());
    }

    @Test
    public void createRMSiteWithSkipAddToFavouritesParameter() throws Exception {
        RMSite toCreate = new RMSite();
        toCreate.setTitle(RM_SITE_TITLE);
        toCreate.setDescription(RM_SITE_DESCRIPTION);
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        NodeRef siteNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)mockedSiteInfo.getShortName()).thenReturn((Object)RM_SITE_ID);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)siteNodeRef);
        Mockito.when((Object)mockedSiteInfo.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION);
        Mockito.when((Object)mockedSiteInfo.getTitle()).thenReturn((Object)RM_SITE_TITLE);
        Mockito.when((Object)mockedSiteInfo.getVisibility()).thenReturn((Object)SiteVisibility.PUBLIC);
        Mockito.when((Object)this.mockedSiteService.createSite((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (SiteVisibility)ArgumentMatchers.any(SiteVisibility.class), (QName)ArgumentMatchers.any(QName.class))).thenReturn((Object)mockedSiteInfo);
        Parameters mockedParameters = (Parameters)Mockito.mock(Parameters.class);
        Mockito.when((Object)mockedParameters.getParameter(PARAM_SKIP_ADDTOFAVORITES)).thenReturn((Object)Boolean.toString(true));
        this.rmSitesImpl.createRMSite(toCreate, mockedParameters);
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createSite(RM_SITE_PRESET, RM_SITE_ID, RM_SITE_TITLE, RM_SITE_DESCRIPTION, SiteVisibility.PUBLIC, RecordsManagementModel.TYPE_RM_SITE);
        ((ImporterService)Mockito.verify((Object)this.mockedImporterService, (VerificationMode)Mockito.times((int)1))).importView((ImportPackageHandler)ArgumentMatchers.any(SiteImportPackageHandler.class), (Location)ArgumentMatchers.any(Location.class), (ImporterBinding)ArgumentMatchers.any(ImporterBinding.class), (ImporterProgress)ArgumentMatchers.eq(null));
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).createContainer(RM_SITE_ID, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        ((FavouritesService)Mockito.verify((Object)this.mockedFavouritesService, (VerificationMode)Mockito.never())).addFavourite((String)ArgumentMatchers.any(String.class), (NodeRef)ArgumentMatchers.any(NodeRef.class));
    }

    @Test
    public void updateRMSite() throws Exception {
        String siteId = RM_SITE_ID;
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        NodeRef siteNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)mockedSiteInfo.getShortName()).thenReturn((Object)siteId);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)siteNodeRef);
        Mockito.when((Object)mockedSiteInfo.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION).thenReturn((Object)RM_SITE_DESCRIPTION_AFTER_UPDATE);
        Mockito.when((Object)mockedSiteInfo.getTitle()).thenReturn((Object)RM_SITE_TITLE).thenReturn((Object)RM_SITE_TITLE_AFTER_UPDATE);
        Mockito.when((Object)mockedSiteInfo.getVisibility()).thenReturn((Object)SiteVisibility.PUBLIC);
        Mockito.when((Object)this.mockedNodeService.getType(siteNodeRef)).thenReturn((Object)RecordsManagementModel.TYPE_RM_SITE);
        Mockito.when((Object)this.mockedSiteService.getSite(siteId)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedSiteService.getMembersRole((String)ArgumentMatchers.eq((Object)siteId), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)RM_SITE_MANAGER_ROLE);
        SiteUpdate mockedSiteUpdate = (SiteUpdate)Mockito.mock(SiteUpdate.class);
        Mockito.when((Object)mockedSiteUpdate.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION_AFTER_UPDATE);
        Mockito.when((Object)mockedSiteUpdate.getTitle()).thenReturn((Object)RM_SITE_TITLE_AFTER_UPDATE);
        Mockito.when((Object)mockedSiteUpdate.wasSet("title")).thenReturn((Object)true);
        Mockito.when((Object)mockedSiteUpdate.wasSet("description")).thenReturn((Object)true);
        Parameters mockedParameters = (Parameters)Mockito.mock(Parameters.class);
        RMSite updatedRMSite = this.rmSitesImpl.updateRMSite(siteId, mockedSiteUpdate, mockedParameters);
        ArgumentCaptor titleCaptor = ArgumentCaptor.forClass(String.class);
        ((SiteInfo)Mockito.verify((Object)mockedSiteInfo, (VerificationMode)Mockito.times((int)1))).setTitle((String)titleCaptor.capture());
        Assert.assertEquals((Object)RM_SITE_TITLE_AFTER_UPDATE, (Object)titleCaptor.getValue());
        ArgumentCaptor descriptionCaptor = ArgumentCaptor.forClass(String.class);
        ((SiteInfo)Mockito.verify((Object)mockedSiteInfo, (VerificationMode)Mockito.times((int)1))).setDescription((String)descriptionCaptor.capture());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION_AFTER_UPDATE, (Object)descriptionCaptor.getValue());
        ((SiteInfo)Mockito.verify((Object)mockedSiteInfo, (VerificationMode)Mockito.never())).setVisibility((SiteVisibility)ArgumentMatchers.any(SiteVisibility.class));
        ((SiteService)Mockito.verify((Object)this.mockedSiteService, (VerificationMode)Mockito.times((int)1))).updateSite((SiteInfo)ArgumentMatchers.any(SiteInfo.class));
        Assert.assertEquals((Object)RMSiteCompliance.STANDARD, (Object)updatedRMSite.getCompliance());
        Assert.assertEquals((Object)RM_SITE_MANAGER_ROLE, (Object)updatedRMSite.getRole());
        Assert.assertEquals((Object)siteId, (Object)updatedRMSite.getId());
        Assert.assertEquals((Object)siteNodeRef.getId(), (Object)updatedRMSite.getGuid());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION_AFTER_UPDATE, (Object)updatedRMSite.getDescription());
        Assert.assertEquals((Object)RM_SITE_TITLE_AFTER_UPDATE, (Object)updatedRMSite.getTitle());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)updatedRMSite.getVisibility());
    }

    @Test
    public void getRMSite() throws Exception {
        String siteId = RM_SITE_ID;
        SiteInfo mockedSiteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
        NodeRef siteNodeRef = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)mockedSiteInfo.getShortName()).thenReturn((Object)siteId);
        Mockito.when((Object)mockedSiteInfo.getNodeRef()).thenReturn((Object)siteNodeRef);
        Mockito.when((Object)mockedSiteInfo.getDescription()).thenReturn((Object)RM_SITE_DESCRIPTION);
        Mockito.when((Object)mockedSiteInfo.getTitle()).thenReturn((Object)RM_SITE_TITLE);
        Mockito.when((Object)mockedSiteInfo.getVisibility()).thenReturn((Object)SiteVisibility.PUBLIC);
        Mockito.when((Object)this.mockedNodeService.getType(siteNodeRef)).thenReturn((Object)RecordsManagementModel.TYPE_RM_SITE);
        Mockito.when((Object)this.mockedSiteService.getSite(siteId)).thenReturn((Object)mockedSiteInfo);
        Mockito.when((Object)this.mockedSiteService.getMembersRole((String)ArgumentMatchers.eq((Object)siteId), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)RM_SITE_MANAGER_ROLE);
        RMSite rmSite = this.rmSitesImpl.getRMSite(siteId);
        Assert.assertEquals((Object)RMSiteCompliance.STANDARD, (Object)rmSite.getCompliance());
        Assert.assertEquals((Object)RM_SITE_MANAGER_ROLE, (Object)rmSite.getRole());
        Assert.assertEquals((Object)siteId, (Object)rmSite.getId());
        Assert.assertEquals((Object)siteNodeRef.getId(), (Object)rmSite.getGuid());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)rmSite.getDescription());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)rmSite.getTitle());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)rmSite.getVisibility());
        Mockito.when((Object)this.mockedNodeService.getType(siteNodeRef)).thenReturn((Object)DOD5015Model.TYPE_DOD_5015_SITE);
        rmSite = this.rmSitesImpl.getRMSite(siteId);
        Assert.assertEquals((Object)RMSiteCompliance.DOD5015, (Object)rmSite.getCompliance());
        Assert.assertEquals((Object)RM_SITE_MANAGER_ROLE, (Object)rmSite.getRole());
        Assert.assertEquals((Object)siteId, (Object)rmSite.getId());
        Assert.assertEquals((Object)siteNodeRef.getId(), (Object)rmSite.getGuid());
        Assert.assertEquals((Object)RM_SITE_DESCRIPTION, (Object)rmSite.getDescription());
        Assert.assertEquals((Object)RM_SITE_TITLE, (Object)rmSite.getTitle());
        Assert.assertEquals((Object)SiteVisibility.PUBLIC, (Object)rmSite.getVisibility());
    }
}

