/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.AuditableActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.InplaceRecordService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HideRecordAction
extends AuditableActionExecuterAbstractBase
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(HideRecordAction.class);
    public static final String NAME = "hide-record";
    private NodeService nodeService;
    private InplaceRecordService inplaceRecordService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setInplaceRecordService(InplaceRecordService inplaceRecordService) {
        this.inplaceRecordService = inplaceRecordService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.hasAspect(actionedUponNodeRef, ASPECT_RECORD)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot hide the document, because '" + actionedUponNodeRef.toString() + "' is not a record."));
            }
        } else {
            this.inplaceRecordService.hideRecord(actionedUponNodeRef);
        }
    }

    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

