/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.PeriodProvider;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.util.StringUtils;

public class ListOfValuesGet
extends DeclarativeWebScript {
    protected RecordsManagementActionService rmActionService;
    protected RecordsManagementAuditService rmAuditService;
    protected RecordsManagementEventService rmEventService;
    protected DispositionService dispositionService;
    protected DictionaryService ddService;
    protected NamespaceService namespaceService;

    public void setRecordsManagementActionService(RecordsManagementActionService rmActionService) {
        this.rmActionService = rmActionService;
    }

    public void setRecordsManagementAuditService(RecordsManagementAuditService rmAuditService) {
        this.rmAuditService = rmAuditService;
    }

    public void setRecordsManagementEventService(RecordsManagementEventService rmEventService) {
        this.rmEventService = rmEventService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setDictionaryService(DictionaryService ddService) {
        this.ddService = ddService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Map<String, Object>> listsModel = new HashMap<String, Map<String, Object>>(4);
        String requestUrl = req.getURL();
        listsModel.put("dispositionActions", this.createDispositionActionsModel(requestUrl));
        listsModel.put("events", this.createEventsModel(requestUrl));
        listsModel.put("periodTypes", this.createPeriodTypesModel(requestUrl));
        listsModel.put("periodProperties", this.createPeriodPropertiesModel(requestUrl));
        listsModel.put("auditEvents", this.createAuditEventsModel(requestUrl));
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("lists", listsModel);
        return model;
    }

    protected Map<String, Object> createDispositionActionsModel(String baseUrl) {
        List<RecordsManagementAction> dispositionActions = this.rmActionService.getDispositionActions();
        ArrayList items = new ArrayList(dispositionActions.size());
        for (RecordsManagementAction dispositionAction : dispositionActions) {
            HashMap<String, String> item = new HashMap<String, String>(2);
            item.put("label", dispositionAction.getLabel());
            item.put("value", dispositionAction.getName());
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("url", baseUrl + "/dispositionactions");
        model.put("items", items);
        return model;
    }

    protected Map<String, Object> createEventsModel(String baseUrl) {
        List<RecordsManagementEvent> events = this.rmEventService.getEvents();
        ArrayList items = new ArrayList(events.size());
        for (RecordsManagementEvent event : events) {
            HashMap<String, Object> item = new HashMap<String, Object>(3);
            item.put("label", event.getDisplayLabel());
            item.put("value", event.getName());
            item.put("automatic", this.rmEventService.getEventType(event.getType()).isAutomaticEvent());
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("url", baseUrl + "/events");
        model.put("items", items);
        return model;
    }

    protected Map<String, Object> createPeriodTypesModel(String baseUrl) {
        Set providers = Period.getProviderNames();
        ArrayList items = new ArrayList(providers.size());
        for (String provider : providers) {
            PeriodProvider pp = Period.getProvider((String)provider);
            if (pp.getPeriodType().equals("cron")) continue;
            HashMap<String, String> item = new HashMap<String, String>(2);
            item.put("label", pp.getDisplayLabel());
            item.put("value", pp.getPeriodType());
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("url", baseUrl + "/periodtypes");
        model.put("items", items);
        return model;
    }

    protected Map<String, Object> createPeriodPropertiesModel(String baseUrl) {
        Collection<DispositionProperty> dispositionProperties = this.dispositionService.getDispositionProperties();
        ArrayList items = new ArrayList(dispositionProperties.size());
        for (DispositionProperty dispositionProperty : dispositionProperties) {
            PropertyDefinition propDef = dispositionProperty.getPropertyDefinition();
            QName propName = dispositionProperty.getQName();
            if (propDef == null) continue;
            HashMap<String, String> item = new HashMap<String, String>(2);
            String propTitle = propDef.getTitle((MessageLookup)this.ddService);
            if (propTitle == null || propTitle.length() == 0) {
                propTitle = StringUtils.capitalize((String)propName.getLocalName());
            }
            item.put("label", propTitle);
            item.put("value", propName.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("url", baseUrl + "/periodproperties");
        model.put("items", items);
        return model;
    }

    protected Map<String, Object> createAuditEventsModel(String baseUrl) {
        List<AuditEvent> auditEvents = this.rmAuditService.getAuditEvents();
        ArrayList items = new ArrayList(auditEvents.size());
        for (AuditEvent event : auditEvents) {
            HashMap<String, String> item = new HashMap<String, String>(2);
            item.put("label", event.getLabel());
            item.put("value", event.getName());
            items.add(item);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("url", baseUrl + "/auditevents");
        model.put("items", items);
        return model;
    }
}

