/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm_share.evaluator;

import java.util.Collections;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ParameterCheck;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.alfresco.web.extensibility.SlingshotEvaluatorUtil;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;

public class IsUserRecordContributor
extends BaseEvaluator {
    private static final String IS_RECORD_CONTRIBUTOR_GROUP_ENABLED = "isRecordContributorGroupEnabled";
    private static final String RECORD_CONTRIBUTOR_GROUP_NAME = "recordContributorGroupName";
    protected SlingshotEvaluatorUtil util = null;

    public void setSlingshotEvaluatorUtil(SlingshotEvaluatorUtil slingshotExtensibilityUtil) {
        this.util = slingshotExtensibilityUtil;
    }

    public boolean evaluate(JSONObject jsonObject) {
        boolean result = true;
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        try {
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node != null) {
                boolean isEnabled = (Boolean)node.get((Object)IS_RECORD_CONTRIBUTOR_GROUP_ENABLED);
                if (isEnabled) {
                    String groupName = (String)node.get((Object)RECORD_CONTRIBUTOR_GROUP_NAME);
                    RequestContext rc = ThreadLocalRequestContext.getRequestContext();
                    result = this.util.isMemberOfGroups(rc, Collections.singletonList("GROUP_" + groupName), true);
                } else {
                    result = true;
                }
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst running UI evaluator: " + err.getMessage());
        }
        return result;
    }
}

