/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.event;

import java.net.ConnectException;
import lombok.Generated;
import org.alfresco.hxi_connector.bulk_ingester.event.IngestEventPublisher;
import org.alfresco.hxi_connector.bulk_ingester.event.IngestEventPublisherConfig;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
class CamelIngestEventPublisher
extends RouteBuilder
implements IngestEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CamelIngestEventPublisher.class);
    private static final String LOCAL_ENDPOINT = "direct:" + CamelIngestEventPublisher.class.getSimpleName();
    private final CamelContext camelContext;
    private final IngestEventPublisherConfig ingestEventPublisherConfig;

    public void configure() {
        ((RouteDefinition)this.from(LOCAL_ENDPOINT).marshal().json().log(LoggingLevel.DEBUG, log, "Sending event ${body}")).to(this.ingestEventPublisherConfig.endpoint());
    }

    @Retryable(retryFor={ConnectException.class}, maxAttemptsExpression="${alfresco.bulk.ingest.publisher.retry.attempts}", backoff=@Backoff(delayExpression="${alfresco.bulk.ingest.publisher.retry.initial-delay}", multiplierExpression="${alfresco.bulk.ingest.publisher.retry.delay-multiplier}"))
    public void publish(IngestEvent ingestEvent) {
        this.camelContext.createProducerTemplate().sendBody(LOCAL_ENDPOINT, (Object)ingestEvent);
    }

    @Generated
    public CamelIngestEventPublisher(CamelContext camelContext, IngestEventPublisherConfig ingestEventPublisherConfig) {
        this.camelContext = camelContext;
        this.ingestEventPublisherConfig = ingestEventPublisherConfig;
    }
}

